// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The definition of a forecast. </summary>
    public partial class ForecastDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ForecastDefinition"/>. </summary>
        /// <param name="forecastType"> The type of the forecast. </param>
        /// <param name="timeframe"> The time frame for pulling data for the forecast. If custom, then a specific time period must be provided. </param>
        /// <param name="dataset"> Has definition for data in this forecast. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataset"/> is null. </exception>
        public ForecastDefinition(ForecastType forecastType, ForecastTimeframe timeframe, ForecastDataset dataset)
        {
            Argument.AssertNotNull(dataset, nameof(dataset));

            ForecastType = forecastType;
            Timeframe = timeframe;
            Dataset = dataset;
        }

        /// <summary> Initializes a new instance of <see cref="ForecastDefinition"/>. </summary>
        /// <param name="forecastType"> The type of the forecast. </param>
        /// <param name="timeframe"> The time frame for pulling data for the forecast. If custom, then a specific time period must be provided. </param>
        /// <param name="timePeriod"> Has time period for pulling data for the forecast. </param>
        /// <param name="dataset"> Has definition for data in this forecast. </param>
        /// <param name="includeActualCost"> A boolean determining if actualCost will be included. </param>
        /// <param name="includeFreshPartialCost"> A boolean determining if FreshPartialCost will be included. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ForecastDefinition(ForecastType forecastType, ForecastTimeframe timeframe, ForecastTimePeriod timePeriod, ForecastDataset dataset, bool? includeActualCost, bool? includeFreshPartialCost, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ForecastType = forecastType;
            Timeframe = timeframe;
            TimePeriod = timePeriod;
            Dataset = dataset;
            IncludeActualCost = includeActualCost;
            IncludeFreshPartialCost = includeFreshPartialCost;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ForecastDefinition"/> for deserialization. </summary>
        internal ForecastDefinition()
        {
        }

        /// <summary> The type of the forecast. </summary>
        public ForecastType ForecastType { get; }
        /// <summary> The time frame for pulling data for the forecast. If custom, then a specific time period must be provided. </summary>
        public ForecastTimeframe Timeframe { get; }
        /// <summary> Has time period for pulling data for the forecast. </summary>
        public ForecastTimePeriod TimePeriod { get; set; }
        /// <summary> Has definition for data in this forecast. </summary>
        public ForecastDataset Dataset { get; }
        /// <summary> A boolean determining if actualCost will be included. </summary>
        public bool? IncludeActualCost { get; set; }
        /// <summary> A boolean determining if FreshPartialCost will be included. </summary>
        public bool? IncludeFreshPartialCost { get; set; }
    }
}
