// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations. </summary>
    public readonly partial struct ExportType : IEquatable<ExportType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UsageValue = "Usage";
        private const string ActualCostValue = "ActualCost";
        private const string AmortizedCostValue = "AmortizedCost";

        /// <summary> Usage. </summary>
        public static ExportType Usage { get; } = new ExportType(UsageValue);
        /// <summary> ActualCost. </summary>
        public static ExportType ActualCost { get; } = new ExportType(ActualCostValue);
        /// <summary> AmortizedCost. </summary>
        public static ExportType AmortizedCost { get; } = new ExportType(AmortizedCostValue);
        /// <summary> Determines if two <see cref="ExportType"/> values are the same. </summary>
        public static bool operator ==(ExportType left, ExportType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportType"/> values are not the same. </summary>
        public static bool operator !=(ExportType left, ExportType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportType"/>. </summary>
        public static implicit operator ExportType(string value) => new ExportType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
