// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The status of the export's schedule. If 'Inactive', the export's schedule is paused. </summary>
    public readonly partial struct ExportScheduleStatusType : IEquatable<ExportScheduleStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportScheduleStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportScheduleStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InactiveValue = "Inactive";

        /// <summary> Active. </summary>
        public static ExportScheduleStatusType Active { get; } = new ExportScheduleStatusType(ActiveValue);
        /// <summary> Inactive. </summary>
        public static ExportScheduleStatusType Inactive { get; } = new ExportScheduleStatusType(InactiveValue);
        /// <summary> Determines if two <see cref="ExportScheduleStatusType"/> values are the same. </summary>
        public static bool operator ==(ExportScheduleStatusType left, ExportScheduleStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportScheduleStatusType"/> values are not the same. </summary>
        public static bool operator !=(ExportScheduleStatusType left, ExportScheduleStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportScheduleStatusType"/>. </summary>
        public static implicit operator ExportScheduleStatusType(string value) => new ExportScheduleStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportScheduleStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportScheduleStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
