// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The type of the export run. </summary>
    public readonly partial struct ExportRunExecutionType : IEquatable<ExportRunExecutionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportRunExecutionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportRunExecutionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnDemandValue = "OnDemand";
        private const string ScheduledValue = "Scheduled";

        /// <summary> OnDemand. </summary>
        public static ExportRunExecutionType OnDemand { get; } = new ExportRunExecutionType(OnDemandValue);
        /// <summary> Scheduled. </summary>
        public static ExportRunExecutionType Scheduled { get; } = new ExportRunExecutionType(ScheduledValue);
        /// <summary> Determines if two <see cref="ExportRunExecutionType"/> values are the same. </summary>
        public static bool operator ==(ExportRunExecutionType left, ExportRunExecutionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportRunExecutionType"/> values are not the same. </summary>
        public static bool operator !=(ExportRunExecutionType left, ExportRunExecutionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportRunExecutionType"/>. </summary>
        public static implicit operator ExportRunExecutionType(string value) => new ExportRunExecutionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportRunExecutionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportRunExecutionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
