// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The last known status of the export run. </summary>
    public readonly partial struct ExportRunExecutionStatus : IEquatable<ExportRunExecutionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportRunExecutionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportRunExecutionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueuedValue = "Queued";
        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";
        private const string TimeoutValue = "Timeout";
        private const string NewDataNotAvailableValue = "NewDataNotAvailable";
        private const string DataNotAvailableValue = "DataNotAvailable";

        /// <summary> Queued. </summary>
        public static ExportRunExecutionStatus Queued { get; } = new ExportRunExecutionStatus(QueuedValue);
        /// <summary> InProgress. </summary>
        public static ExportRunExecutionStatus InProgress { get; } = new ExportRunExecutionStatus(InProgressValue);
        /// <summary> Completed. </summary>
        public static ExportRunExecutionStatus Completed { get; } = new ExportRunExecutionStatus(CompletedValue);
        /// <summary> Failed. </summary>
        public static ExportRunExecutionStatus Failed { get; } = new ExportRunExecutionStatus(FailedValue);
        /// <summary> Timeout. </summary>
        public static ExportRunExecutionStatus Timeout { get; } = new ExportRunExecutionStatus(TimeoutValue);
        /// <summary> NewDataNotAvailable. </summary>
        public static ExportRunExecutionStatus NewDataNotAvailable { get; } = new ExportRunExecutionStatus(NewDataNotAvailableValue);
        /// <summary> DataNotAvailable. </summary>
        public static ExportRunExecutionStatus DataNotAvailable { get; } = new ExportRunExecutionStatus(DataNotAvailableValue);
        /// <summary> Determines if two <see cref="ExportRunExecutionStatus"/> values are the same. </summary>
        public static bool operator ==(ExportRunExecutionStatus left, ExportRunExecutionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportRunExecutionStatus"/> values are not the same. </summary>
        public static bool operator !=(ExportRunExecutionStatus left, ExportRunExecutionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportRunExecutionStatus"/>. </summary>
        public static implicit operator ExportRunExecutionStatus(string value) => new ExportRunExecutionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportRunExecutionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportRunExecutionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
