// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The start and end date for recurrence schedule. </summary>
    public partial class ExportRecurrencePeriod
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExportRecurrencePeriod"/>. </summary>
        /// <param name="from"> The start date of recurrence. </param>
        public ExportRecurrencePeriod(DateTimeOffset @from)
        {
            From = @from;
        }

        /// <summary> Initializes a new instance of <see cref="ExportRecurrencePeriod"/>. </summary>
        /// <param name="from"> The start date of recurrence. </param>
        /// <param name="to"> The end date of recurrence. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExportRecurrencePeriod(DateTimeOffset @from, DateTimeOffset? to, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            From = @from;
            To = to;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExportRecurrencePeriod"/> for deserialization. </summary>
        internal ExportRecurrencePeriod()
        {
        }

        /// <summary> The start date of recurrence. </summary>
        public DateTimeOffset From { get; set; }
        /// <summary> The end date of recurrence. </summary>
        public DateTimeOffset? To { get; set; }
    }
}
