// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> This represents the blob storage account location where exports of costs will be delivered. There are two ways to configure the destination. The approach recommended for most customers is to specify the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports resource provider in order to give Cost Management services access to the storage. When creating an export in the Azure portal this registration is performed automatically but API users may need to register the subscription explicitly (for more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ). </summary>
    public partial class ExportDeliveryDestination
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExportDeliveryDestination"/>. </summary>
        /// <param name="container"> The name of the container where exports will be uploaded. If the container does not exist it will be created. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="container"/> is null. </exception>
        public ExportDeliveryDestination(string container)
        {
            Argument.AssertNotNull(container, nameof(container));

            Container = container;
        }

        /// <summary> Initializes a new instance of <see cref="ExportDeliveryDestination"/>. </summary>
        /// <param name="resourceId"> The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified. </param>
        /// <param name="container"> The name of the container where exports will be uploaded. If the container does not exist it will be created. </param>
        /// <param name="rootFolderPath"> The name of the directory where exports will be uploaded. </param>
        /// <param name="sasToken"> A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified. </param>
        /// <param name="storageAccount"> The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExportDeliveryDestination(ResourceIdentifier resourceId, string container, string rootFolderPath, string sasToken, string storageAccount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            Container = container;
            RootFolderPath = rootFolderPath;
            SasToken = sasToken;
            StorageAccount = storageAccount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExportDeliveryDestination"/> for deserialization. </summary>
        internal ExportDeliveryDestination()
        {
        }

        /// <summary> The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> The name of the container where exports will be uploaded. If the container does not exist it will be created. </summary>
        public string Container { get; set; }
        /// <summary> The name of the directory where exports will be uploaded. </summary>
        public string RootFolderPath { get; set; }
        /// <summary> A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified. </summary>
        public string SasToken { get; set; }
        /// <summary> The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId. </summary>
        public string StorageAccount { get; set; }
    }
}
