// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The definition of an export. </summary>
    public partial class ExportDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExportDefinition"/>. </summary>
        /// <param name="exportType"> The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations. </param>
        /// <param name="timeframe"> The time frame for pulling data for the export. If custom, then a specific time period must be provided. </param>
        public ExportDefinition(ExportType exportType, TimeframeType timeframe)
        {
            ExportType = exportType;
            Timeframe = timeframe;
        }

        /// <summary> Initializes a new instance of <see cref="ExportDefinition"/>. </summary>
        /// <param name="exportType"> The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations. </param>
        /// <param name="timeframe"> The time frame for pulling data for the export. If custom, then a specific time period must be provided. </param>
        /// <param name="timePeriod"> Has time period for pulling data for the export. </param>
        /// <param name="dataSet"> The definition for data in the export. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExportDefinition(ExportType exportType, TimeframeType timeframe, ExportTimePeriod timePeriod, ExportDataset dataSet, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExportType = exportType;
            Timeframe = timeframe;
            TimePeriod = timePeriod;
            DataSet = dataSet;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExportDefinition"/> for deserialization. </summary>
        internal ExportDefinition()
        {
        }

        /// <summary> The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations. </summary>
        public ExportType ExportType { get; set; }
        /// <summary> The time frame for pulling data for the export. If custom, then a specific time period must be provided. </summary>
        public TimeframeType Timeframe { get; set; }
        /// <summary> Has time period for pulling data for the export. </summary>
        public ExportTimePeriod TimePeriod { get; set; }
        /// <summary> The definition for data in the export. </summary>
        public ExportDataset DataSet { get; set; }
    }
}
