// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The definition for data in the export. </summary>
    public partial class ExportDataset
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExportDataset"/>. </summary>
        public ExportDataset()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExportDataset"/>. </summary>
        /// <param name="granularity"> The granularity of rows in the export. Currently only 'Daily' is supported. </param>
        /// <param name="configuration"> The export dataset configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExportDataset(GranularityType? granularity, ExportDatasetConfiguration configuration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Granularity = granularity;
            Configuration = configuration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The granularity of rows in the export. Currently only 'Daily' is supported. </summary>
        public GranularityType? Granularity { get; set; }
        /// <summary> The export dataset configuration. </summary>
        internal ExportDatasetConfiguration Configuration { get; set; }
        /// <summary> Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples). </summary>
        public IList<string> Columns
        {
            get
            {
                if (Configuration is null)
                    Configuration = new ExportDatasetConfiguration();
                return Configuration.Columns;
            }
        }
    }
}
