// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The reason why the given name is not available. </summary>
    public readonly partial struct CostManagementUnavailabilityReason : IEquatable<CostManagementUnavailabilityReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementUnavailabilityReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementUnavailabilityReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static CostManagementUnavailabilityReason Invalid { get; } = new CostManagementUnavailabilityReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static CostManagementUnavailabilityReason AlreadyExists { get; } = new CostManagementUnavailabilityReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="CostManagementUnavailabilityReason"/> values are the same. </summary>
        public static bool operator ==(CostManagementUnavailabilityReason left, CostManagementUnavailabilityReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementUnavailabilityReason"/> values are not the same. </summary>
        public static bool operator !=(CostManagementUnavailabilityReason left, CostManagementUnavailabilityReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementUnavailabilityReason"/>. </summary>
        public static implicit operator CostManagementUnavailabilityReason(string value) => new CostManagementUnavailabilityReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementUnavailabilityReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementUnavailabilityReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
