// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> List of Dimension. </summary>
    public partial class CostManagementDimension : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CostManagementDimension"/>. </summary>
        internal CostManagementDimension()
        {
            Data = new ChangeTrackingList<string>();
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="CostManagementDimension"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Dimension description. </param>
        /// <param name="isFilterEnabled"> Filter enabled. </param>
        /// <param name="isGroupingEnabled"> Grouping enabled. </param>
        /// <param name="data"> Dimension data. </param>
        /// <param name="total"> Total number of data for the dimension. </param>
        /// <param name="category"> Dimension category. </param>
        /// <param name="usageStart"> Usage start. </param>
        /// <param name="usageEnd"> Usage end. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="location"> Location of the resource. </param>
        /// <param name="sku"> SKU of the resource. </param>
        /// <param name="eTag"> ETag of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CostManagementDimension(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, bool? isFilterEnabled, bool? isGroupingEnabled, IReadOnlyList<string> data, int? total, string category, DateTimeOffset? usageStart, DateTimeOffset? usageEnd, string nextLink, AzureLocation? location, string sku, ETag? eTag, IReadOnlyDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            IsFilterEnabled = isFilterEnabled;
            IsGroupingEnabled = isGroupingEnabled;
            Data = data;
            Total = total;
            Category = category;
            UsageStart = usageStart;
            UsageEnd = usageEnd;
            NextLink = nextLink;
            Location = location;
            Sku = sku;
            ETag = eTag;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Dimension description. </summary>
        public string Description { get; }
        /// <summary> Filter enabled. </summary>
        public bool? IsFilterEnabled { get; }
        /// <summary> Grouping enabled. </summary>
        public bool? IsGroupingEnabled { get; }
        /// <summary> Dimension data. </summary>
        public IReadOnlyList<string> Data { get; }
        /// <summary> Total number of data for the dimension. </summary>
        public int? Total { get; }
        /// <summary> Dimension category. </summary>
        public string Category { get; }
        /// <summary> Usage start. </summary>
        public DateTimeOffset? UsageStart { get; }
        /// <summary> Usage end. </summary>
        public DateTimeOffset? UsageEnd { get; }
        /// <summary> The link (url) to the next page of results. </summary>
        public string NextLink { get; }
        /// <summary> Location of the resource. </summary>
        public AzureLocation? Location { get; }
        /// <summary> SKU of the resource. </summary>
        public string Sku { get; }
        /// <summary> ETag of the resource. </summary>
        public ETag? ETag { get; }
        /// <summary> Resource tags. </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
    }
}
