// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> type of alert. </summary>
    public readonly partial struct CostManagementAlertType : IEquatable<CostManagementAlertType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementAlertType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementAlertType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BudgetValue = "Budget";
        private const string InvoiceValue = "Invoice";
        private const string CreditValue = "Credit";
        private const string QuotaValue = "Quota";
        private const string GeneralValue = "General";
        private const string XCloudValue = "xCloud";
        private const string BudgetForecastValue = "BudgetForecast";

        /// <summary> Budget. </summary>
        public static CostManagementAlertType Budget { get; } = new CostManagementAlertType(BudgetValue);
        /// <summary> Invoice. </summary>
        public static CostManagementAlertType Invoice { get; } = new CostManagementAlertType(InvoiceValue);
        /// <summary> Credit. </summary>
        public static CostManagementAlertType Credit { get; } = new CostManagementAlertType(CreditValue);
        /// <summary> Quota. </summary>
        public static CostManagementAlertType Quota { get; } = new CostManagementAlertType(QuotaValue);
        /// <summary> General. </summary>
        public static CostManagementAlertType General { get; } = new CostManagementAlertType(GeneralValue);
        /// <summary> xCloud. </summary>
        public static CostManagementAlertType XCloud { get; } = new CostManagementAlertType(XCloudValue);
        /// <summary> BudgetForecast. </summary>
        public static CostManagementAlertType BudgetForecast { get; } = new CostManagementAlertType(BudgetForecastValue);
        /// <summary> Determines if two <see cref="CostManagementAlertType"/> values are the same. </summary>
        public static bool operator ==(CostManagementAlertType left, CostManagementAlertType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementAlertType"/> values are not the same. </summary>
        public static bool operator !=(CostManagementAlertType left, CostManagementAlertType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementAlertType"/>. </summary>
        public static implicit operator CostManagementAlertType(string value) => new CostManagementAlertType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementAlertType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementAlertType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
