// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> alert status. </summary>
    public readonly partial struct CostManagementAlertStatus : IEquatable<CostManagementAlertStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementAlertStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementAlertStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ActiveValue = "Active";
        private const string OverriddenValue = "Overridden";
        private const string ResolvedValue = "Resolved";
        private const string DismissedValue = "Dismissed";

        /// <summary> None. </summary>
        public static CostManagementAlertStatus None { get; } = new CostManagementAlertStatus(NoneValue);
        /// <summary> Active. </summary>
        public static CostManagementAlertStatus Active { get; } = new CostManagementAlertStatus(ActiveValue);
        /// <summary> Overridden. </summary>
        public static CostManagementAlertStatus Overridden { get; } = new CostManagementAlertStatus(OverriddenValue);
        /// <summary> Resolved. </summary>
        public static CostManagementAlertStatus Resolved { get; } = new CostManagementAlertStatus(ResolvedValue);
        /// <summary> Dismissed. </summary>
        public static CostManagementAlertStatus Dismissed { get; } = new CostManagementAlertStatus(DismissedValue);
        /// <summary> Determines if two <see cref="CostManagementAlertStatus"/> values are the same. </summary>
        public static bool operator ==(CostManagementAlertStatus left, CostManagementAlertStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementAlertStatus"/> values are not the same. </summary>
        public static bool operator !=(CostManagementAlertStatus left, CostManagementAlertStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementAlertStatus"/>. </summary>
        public static implicit operator CostManagementAlertStatus(string value) => new CostManagementAlertStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementAlertStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementAlertStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
