// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Source of alert. </summary>
    public readonly partial struct CostManagementAlertSource : IEquatable<CostManagementAlertSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementAlertSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementAlertSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PresetValue = "Preset";
        private const string UserValue = "User";

        /// <summary> Preset. </summary>
        public static CostManagementAlertSource Preset { get; } = new CostManagementAlertSource(PresetValue);
        /// <summary> User. </summary>
        public static CostManagementAlertSource User { get; } = new CostManagementAlertSource(UserValue);
        /// <summary> Determines if two <see cref="CostManagementAlertSource"/> values are the same. </summary>
        public static bool operator ==(CostManagementAlertSource left, CostManagementAlertSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementAlertSource"/> values are not the same. </summary>
        public static bool operator !=(CostManagementAlertSource left, CostManagementAlertSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementAlertSource"/>. </summary>
        public static implicit operator CostManagementAlertSource(string value) => new CostManagementAlertSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementAlertSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementAlertSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
