// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> operator used to compare currentSpend with amount. </summary>
    public readonly partial struct CostManagementAlertOperator : IEquatable<CostManagementAlertOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementAlertOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementAlertOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string EqualToValue = "EqualTo";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualToValue = "GreaterThanOrEqualTo";
        private const string LessThanValue = "LessThan";
        private const string LessThanOrEqualToValue = "LessThanOrEqualTo";

        /// <summary> None. </summary>
        public static CostManagementAlertOperator None { get; } = new CostManagementAlertOperator(NoneValue);
        /// <summary> EqualTo. </summary>
        public static CostManagementAlertOperator EqualTo { get; } = new CostManagementAlertOperator(EqualToValue);
        /// <summary> GreaterThan. </summary>
        public static CostManagementAlertOperator GreaterThan { get; } = new CostManagementAlertOperator(GreaterThanValue);
        /// <summary> GreaterThanOrEqualTo. </summary>
        public static CostManagementAlertOperator GreaterThanOrEqualTo { get; } = new CostManagementAlertOperator(GreaterThanOrEqualToValue);
        /// <summary> LessThan. </summary>
        public static CostManagementAlertOperator LessThan { get; } = new CostManagementAlertOperator(LessThanValue);
        /// <summary> LessThanOrEqualTo. </summary>
        public static CostManagementAlertOperator LessThanOrEqualTo { get; } = new CostManagementAlertOperator(LessThanOrEqualToValue);
        /// <summary> Determines if two <see cref="CostManagementAlertOperator"/> values are the same. </summary>
        public static bool operator ==(CostManagementAlertOperator left, CostManagementAlertOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementAlertOperator"/> values are not the same. </summary>
        public static bool operator !=(CostManagementAlertOperator left, CostManagementAlertOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementAlertOperator"/>. </summary>
        public static implicit operator CostManagementAlertOperator(string value) => new CostManagementAlertOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementAlertOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementAlertOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
