// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Alert category. </summary>
    public readonly partial struct CostManagementAlertCategory : IEquatable<CostManagementAlertCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CostManagementAlertCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CostManagementAlertCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CostValue = "Cost";
        private const string UsageValue = "Usage";
        private const string BillingValue = "Billing";
        private const string SystemValue = "System";

        /// <summary> Cost. </summary>
        public static CostManagementAlertCategory Cost { get; } = new CostManagementAlertCategory(CostValue);
        /// <summary> Usage. </summary>
        public static CostManagementAlertCategory Usage { get; } = new CostManagementAlertCategory(UsageValue);
        /// <summary> Billing. </summary>
        public static CostManagementAlertCategory Billing { get; } = new CostManagementAlertCategory(BillingValue);
        /// <summary> System. </summary>
        public static CostManagementAlertCategory System { get; } = new CostManagementAlertCategory(SystemValue);
        /// <summary> Determines if two <see cref="CostManagementAlertCategory"/> values are the same. </summary>
        public static bool operator ==(CostManagementAlertCategory left, CostManagementAlertCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CostManagementAlertCategory"/> values are not the same. </summary>
        public static bool operator !=(CostManagementAlertCategory left, CostManagementAlertCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CostManagementAlertCategory"/>. </summary>
        public static implicit operator CostManagementAlertCategory(string value) => new CostManagementAlertCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CostManagementAlertCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CostManagementAlertCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
