// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Properties of an async benefit utilization summaries request. </summary>
    public partial class BenefitUtilizationSummariesContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BenefitUtilizationSummariesContent"/>. </summary>
        /// <param name="grain"> The grain the summaries data is served at in the report. Accepted values are 'Daily' or 'Monthly'. </param>
        /// <param name="startOn"> The start date of the summaries data that will be served in the report. </param>
        /// <param name="endOn"> The end date of the summaries data that will be served in the report. </param>
        public BenefitUtilizationSummariesContent(BenefitRecommendationUsageGrain grain, DateTimeOffset startOn, DateTimeOffset endOn)
        {
            Grain = grain;
            StartOn = startOn;
            EndOn = endOn;
        }

        /// <summary> Initializes a new instance of <see cref="BenefitUtilizationSummariesContent"/>. </summary>
        /// <param name="billingAccountId"> Billing account the benefit utilization summaries report is for. Required for billing account and billing profile scopes. Not supported for any benefit scopes. </param>
        /// <param name="billingProfileId"> Billing profile id the benefit utilization summaries report is for. Required for billing profile scope. Not supported for billing account or any benefit scopes. </param>
        /// <param name="benefitOrderId"> Benefit order id the benefit utilization summaries report is for. Required for benefit order and benefit id scopes. Not supported for any billing scopes. </param>
        /// <param name="benefitId"> Benefit id the benefit utilization summaries report is for. Required for benefit id scope. Not supported for benefit order or any billing scopes. </param>
        /// <param name="grain"> The grain the summaries data is served at in the report. Accepted values are 'Daily' or 'Monthly'. </param>
        /// <param name="startOn"> The start date of the summaries data that will be served in the report. </param>
        /// <param name="endOn"> The end date of the summaries data that will be served in the report. </param>
        /// <param name="kind"> The type of benefit data requested. Required for billing account and billing profile scopes. Implied and not to be passed at benefit scopes. Supported values are Reservation and SavingsPlan. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BenefitUtilizationSummariesContent(string billingAccountId, string billingProfileId, string benefitOrderId, string benefitId, BenefitRecommendationUsageGrain grain, DateTimeOffset startOn, DateTimeOffset endOn, BillingAccountBenefitKind? kind, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingAccountId = billingAccountId;
            BillingProfileId = billingProfileId;
            BenefitOrderId = benefitOrderId;
            BenefitId = benefitId;
            Grain = grain;
            StartOn = startOn;
            EndOn = endOn;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BenefitUtilizationSummariesContent"/> for deserialization. </summary>
        internal BenefitUtilizationSummariesContent()
        {
        }

        /// <summary> Billing account the benefit utilization summaries report is for. Required for billing account and billing profile scopes. Not supported for any benefit scopes. </summary>
        public string BillingAccountId { get; set; }
        /// <summary> Billing profile id the benefit utilization summaries report is for. Required for billing profile scope. Not supported for billing account or any benefit scopes. </summary>
        public string BillingProfileId { get; set; }
        /// <summary> Benefit order id the benefit utilization summaries report is for. Required for benefit order and benefit id scopes. Not supported for any billing scopes. </summary>
        public string BenefitOrderId { get; set; }
        /// <summary> Benefit id the benefit utilization summaries report is for. Required for benefit id scope. Not supported for benefit order or any billing scopes. </summary>
        public string BenefitId { get; set; }
        /// <summary> The grain the summaries data is served at in the report. Accepted values are 'Daily' or 'Monthly'. </summary>
        public BenefitRecommendationUsageGrain Grain { get; set; }
        /// <summary> The start date of the summaries data that will be served in the report. </summary>
        public DateTimeOffset StartOn { get; set; }
        /// <summary> The end date of the summaries data that will be served in the report. </summary>
        public DateTimeOffset EndOn { get; set; }
        /// <summary> The type of benefit data requested. Required for billing account and billing profile scopes. Implied and not to be passed at benefit scopes. Supported values are Reservation and SavingsPlan. </summary>
        public BillingAccountBenefitKind? Kind { get; set; }
    }
}
