// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Grain which corresponds to value. </summary>
    public readonly partial struct BenefitRecommendationUsageGrain : IEquatable<BenefitRecommendationUsageGrain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BenefitRecommendationUsageGrain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BenefitRecommendationUsageGrain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HourlyValue = "Hourly";
        private const string DailyValue = "Daily";
        private const string MonthlyValue = "Monthly";

        /// <summary> Hourly grain corresponds to value per hour. </summary>
        public static BenefitRecommendationUsageGrain Hourly { get; } = new BenefitRecommendationUsageGrain(HourlyValue);
        /// <summary> Hourly grain corresponds to value per day. </summary>
        public static BenefitRecommendationUsageGrain Daily { get; } = new BenefitRecommendationUsageGrain(DailyValue);
        /// <summary> Hourly grain corresponds to value per month. </summary>
        public static BenefitRecommendationUsageGrain Monthly { get; } = new BenefitRecommendationUsageGrain(MonthlyValue);
        /// <summary> Determines if two <see cref="BenefitRecommendationUsageGrain"/> values are the same. </summary>
        public static bool operator ==(BenefitRecommendationUsageGrain left, BenefitRecommendationUsageGrain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BenefitRecommendationUsageGrain"/> values are not the same. </summary>
        public static bool operator !=(BenefitRecommendationUsageGrain left, BenefitRecommendationUsageGrain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BenefitRecommendationUsageGrain"/>. </summary>
        public static implicit operator BenefitRecommendationUsageGrain(string value) => new BenefitRecommendationUsageGrain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BenefitRecommendationUsageGrain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BenefitRecommendationUsageGrain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
