// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Kind of the recommendation scope. </summary>
    internal readonly partial struct BenefitRecommendationScope : IEquatable<BenefitRecommendationScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BenefitRecommendationScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BenefitRecommendationScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string SharedValue = "Shared";

        /// <summary> Single scope recommendation. </summary>
        public static BenefitRecommendationScope Single { get; } = new BenefitRecommendationScope(SingleValue);
        /// <summary> Shared scope recommendation. </summary>
        public static BenefitRecommendationScope Shared { get; } = new BenefitRecommendationScope(SharedValue);
        /// <summary> Determines if two <see cref="BenefitRecommendationScope"/> values are the same. </summary>
        public static bool operator ==(BenefitRecommendationScope left, BenefitRecommendationScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BenefitRecommendationScope"/> values are not the same. </summary>
        public static bool operator !=(BenefitRecommendationScope left, BenefitRecommendationScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BenefitRecommendationScope"/>. </summary>
        public static implicit operator BenefitRecommendationScope(string value) => new BenefitRecommendationScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BenefitRecommendationScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BenefitRecommendationScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
