// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CostManagement.Models
{
    [PersistableModelProxy(typeof(UnknownBenefitRecommendationProperties))]
    public partial class BenefitRecommendationProperties : IUtf8JsonSerializable, IJsonModel<BenefitRecommendationProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BenefitRecommendationProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BenefitRecommendationProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BenefitRecommendationProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(FirstConsumptionOn))
            {
                writer.WritePropertyName("firstConsumptionDate"u8);
                writer.WriteStringValue(FirstConsumptionOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastConsumptionOn))
            {
                writer.WritePropertyName("lastConsumptionDate"u8);
                writer.WriteStringValue(LastConsumptionOn.Value, "O");
            }
            if (Optional.IsDefined(LookBackPeriod))
            {
                writer.WritePropertyName("lookBackPeriod"u8);
                writer.WriteStringValue(LookBackPeriod.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TotalHours))
            {
                writer.WritePropertyName("totalHours"u8);
                writer.WriteNumberValue(TotalHours.Value);
            }
            if (Optional.IsDefined(Usage))
            {
                writer.WritePropertyName("usage"u8);
                writer.WriteObjectValue(Usage, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ArmSkuName))
            {
                writer.WritePropertyName("armSkuName"u8);
                writer.WriteStringValue(ArmSkuName);
            }
            if (Optional.IsDefined(Term))
            {
                writer.WritePropertyName("term"u8);
                writer.WriteStringValue(Term.Value.ToString());
            }
            if (Optional.IsDefined(CommitmentGranularity))
            {
                writer.WritePropertyName("commitmentGranularity"u8);
                writer.WriteStringValue(CommitmentGranularity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CurrencyCode))
            {
                writer.WritePropertyName("currencyCode"u8);
                writer.WriteStringValue(CurrencyCode);
            }
            if (options.Format != "W" && Optional.IsDefined(CostWithoutBenefit))
            {
                writer.WritePropertyName("costWithoutBenefit"u8);
                writer.WriteNumberValue(CostWithoutBenefit.Value);
            }
            if (Optional.IsDefined(RecommendationDetails))
            {
                writer.WritePropertyName("recommendationDetails"u8);
                writer.WriteObjectValue(RecommendationDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AllRecommendationDetails))
            {
                writer.WritePropertyName("allRecommendationDetails"u8);
                writer.WriteObjectValue(AllRecommendationDetails, options);
            }
            writer.WritePropertyName("scope"u8);
            writer.WriteStringValue(Scope.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BenefitRecommendationProperties IJsonModel<BenefitRecommendationProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BenefitRecommendationProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBenefitRecommendationProperties(document.RootElement, options);
        }

        internal static BenefitRecommendationProperties DeserializeBenefitRecommendationProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("scope", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Shared": return SharedScopeBenefitRecommendationProperties.DeserializeSharedScopeBenefitRecommendationProperties(element, options);
                    case "Single": return SingleScopeBenefitRecommendationProperties.DeserializeSingleScopeBenefitRecommendationProperties(element, options);
                }
            }
            return UnknownBenefitRecommendationProperties.DeserializeUnknownBenefitRecommendationProperties(element, options);
        }

        BinaryData IPersistableModel<BenefitRecommendationProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BenefitRecommendationProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BenefitRecommendationProperties IPersistableModel<BenefitRecommendationProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBenefitRecommendationProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BenefitRecommendationProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BenefitRecommendationProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
