// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Object representing the report url and valid until date of the async report generated. </summary>
    public partial class AsyncOperationStatusProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AsyncOperationStatusProperties"/>. </summary>
        internal AsyncOperationStatusProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AsyncOperationStatusProperties"/>. </summary>
        /// <param name="reportUri"> Sas url to the async benefit utilization summaries report. Will be empty if the report is in Running or Failed state. </param>
        /// <param name="secondaryReportUri"> Sas url to async benefit utilization summaries report in secondary storage in case of primary outage. Will be empty if the report is in Running or Failed state. </param>
        /// <param name="validUntil"> The date that the sas url provided in reportUrl expires. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AsyncOperationStatusProperties(BenefitUtilizationSummaryReportSchema? reportUri, BenefitUtilizationSummaryReportSchema? secondaryReportUri, DateTimeOffset? validUntil, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReportUri = reportUri;
            SecondaryReportUri = secondaryReportUri;
            ValidUntil = validUntil;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Sas url to the async benefit utilization summaries report. Will be empty if the report is in Running or Failed state. </summary>
        public BenefitUtilizationSummaryReportSchema? ReportUri { get; }
        /// <summary> Sas url to async benefit utilization summaries report in secondary storage in case of primary outage. Will be empty if the report is in Running or Failed state. </summary>
        public BenefitUtilizationSummaryReportSchema? SecondaryReportUri { get; }
        /// <summary> The date that the sas url provided in reportUrl expires. </summary>
        public DateTimeOffset? ValidUntil { get; }
    }
}
