// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Benefit recommendation details. </summary>
    public partial class AllSavingsBenefitDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AllSavingsBenefitDetails"/>. </summary>
        public AllSavingsBenefitDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AllSavingsBenefitDetails"/>. </summary>
        /// <param name="overageCost"> The difference between total cost and benefit cost for the 'totalHours' in the look-back period. </param>
        /// <param name="benefitCost"> The estimated cost with benefit for the 'totalHours' in the look-back period. It's equal to (commitmentAmount * totalHours). </param>
        /// <param name="totalCost"> Total cost, which is sum of benefit cost and overage cost. </param>
        /// <param name="savingsAmount"> The amount saved for the 'totalHours' in the look-back period, by purchasing the recommended quantity of the benefit. </param>
        /// <param name="savingsPercentage"> The savings in percentage for the 'totalHours' in the look-back period, by purchasing the recommended quantity of benefit. </param>
        /// <param name="coveragePercentage"> Estimated benefit coverage percentage for the 'totalHours' in the look-back period, with this commitment. </param>
        /// <param name="commitmentAmount"> The commitment amount at the commitmentGranularity. </param>
        /// <param name="averageUtilizationPercentage"> Estimated average utilization percentage for the 'totalHours' in the look-back period, with this commitment. </param>
        /// <param name="wastageCost"> Estimated unused portion of the 'benefitCost'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AllSavingsBenefitDetails(decimal? overageCost, decimal? benefitCost, decimal? totalCost, decimal? savingsAmount, decimal? savingsPercentage, decimal? coveragePercentage, decimal? commitmentAmount, decimal? averageUtilizationPercentage, decimal? wastageCost, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OverageCost = overageCost;
            BenefitCost = benefitCost;
            TotalCost = totalCost;
            SavingsAmount = savingsAmount;
            SavingsPercentage = savingsPercentage;
            CoveragePercentage = coveragePercentage;
            CommitmentAmount = commitmentAmount;
            AverageUtilizationPercentage = averageUtilizationPercentage;
            WastageCost = wastageCost;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The difference between total cost and benefit cost for the 'totalHours' in the look-back period. </summary>
        public decimal? OverageCost { get; }
        /// <summary> The estimated cost with benefit for the 'totalHours' in the look-back period. It's equal to (commitmentAmount * totalHours). </summary>
        public decimal? BenefitCost { get; }
        /// <summary> Total cost, which is sum of benefit cost and overage cost. </summary>
        public decimal? TotalCost { get; }
        /// <summary> The amount saved for the 'totalHours' in the look-back period, by purchasing the recommended quantity of the benefit. </summary>
        public decimal? SavingsAmount { get; }
        /// <summary> The savings in percentage for the 'totalHours' in the look-back period, by purchasing the recommended quantity of benefit. </summary>
        public decimal? SavingsPercentage { get; }
        /// <summary> Estimated benefit coverage percentage for the 'totalHours' in the look-back period, with this commitment. </summary>
        public decimal? CoveragePercentage { get; }
        /// <summary> The commitment amount at the commitmentGranularity. </summary>
        public decimal? CommitmentAmount { get; }
        /// <summary> Estimated average utilization percentage for the 'totalHours' in the look-back period, with this commitment. </summary>
        public decimal? AverageUtilizationPercentage { get; }
        /// <summary> Estimated unused portion of the 'benefitCost'. </summary>
        public decimal? WastageCost { get; }
    }
}
