// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CostManagement.Models
{
    public partial class AllSavingsBenefitDetails : IUtf8JsonSerializable, IJsonModel<AllSavingsBenefitDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AllSavingsBenefitDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AllSavingsBenefitDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AllSavingsBenefitDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AllSavingsBenefitDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(OverageCost))
            {
                writer.WritePropertyName("overageCost"u8);
                writer.WriteNumberValue(OverageCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BenefitCost))
            {
                writer.WritePropertyName("benefitCost"u8);
                writer.WriteNumberValue(BenefitCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalCost))
            {
                writer.WritePropertyName("totalCost"u8);
                writer.WriteNumberValue(TotalCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SavingsAmount))
            {
                writer.WritePropertyName("savingsAmount"u8);
                writer.WriteNumberValue(SavingsAmount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SavingsPercentage))
            {
                writer.WritePropertyName("savingsPercentage"u8);
                writer.WriteNumberValue(SavingsPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CoveragePercentage))
            {
                writer.WritePropertyName("coveragePercentage"u8);
                writer.WriteNumberValue(CoveragePercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CommitmentAmount))
            {
                writer.WritePropertyName("commitmentAmount"u8);
                writer.WriteNumberValue(CommitmentAmount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AverageUtilizationPercentage))
            {
                writer.WritePropertyName("averageUtilizationPercentage"u8);
                writer.WriteNumberValue(AverageUtilizationPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(WastageCost))
            {
                writer.WritePropertyName("wastageCost"u8);
                writer.WriteNumberValue(WastageCost.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AllSavingsBenefitDetails IJsonModel<AllSavingsBenefitDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AllSavingsBenefitDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AllSavingsBenefitDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAllSavingsBenefitDetails(document.RootElement, options);
        }

        internal static AllSavingsBenefitDetails DeserializeAllSavingsBenefitDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            decimal? overageCost = default;
            decimal? benefitCost = default;
            decimal? totalCost = default;
            decimal? savingsAmount = default;
            decimal? savingsPercentage = default;
            decimal? coveragePercentage = default;
            decimal? commitmentAmount = default;
            decimal? averageUtilizationPercentage = default;
            decimal? wastageCost = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("overageCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    overageCost = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("benefitCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    benefitCost = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("totalCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalCost = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("savingsAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    savingsAmount = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("savingsPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    savingsPercentage = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("coveragePercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    coveragePercentage = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("commitmentAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    commitmentAmount = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("averageUtilizationPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    averageUtilizationPercentage = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("wastageCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wastageCost = property.Value.GetDecimal();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AllSavingsBenefitDetails(
                overageCost,
                benefitCost,
                totalCost,
                savingsAmount,
                savingsPercentage,
                coveragePercentage,
                commitmentAmount,
                averageUtilizationPercentage,
                wastageCost,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AllSavingsBenefitDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AllSavingsBenefitDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AllSavingsBenefitDetails)} does not support writing '{options.Format}' format.");
            }
        }

        AllSavingsBenefitDetails IPersistableModel<AllSavingsBenefitDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AllSavingsBenefitDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAllSavingsBenefitDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AllSavingsBenefitDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AllSavingsBenefitDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
