// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Type of timegrain cadence. </summary>
    public readonly partial struct AlertTimeGrainType : IEquatable<AlertTimeGrainType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AlertTimeGrainType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AlertTimeGrainType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string MonthlyValue = "Monthly";
        private const string QuarterlyValue = "Quarterly";
        private const string AnnuallyValue = "Annually";
        private const string BillingMonthValue = "BillingMonth";
        private const string BillingQuarterValue = "BillingQuarter";
        private const string BillingAnnualValue = "BillingAnnual";

        /// <summary> None. </summary>
        public static AlertTimeGrainType None { get; } = new AlertTimeGrainType(NoneValue);
        /// <summary> Monthly. </summary>
        public static AlertTimeGrainType Monthly { get; } = new AlertTimeGrainType(MonthlyValue);
        /// <summary> Quarterly. </summary>
        public static AlertTimeGrainType Quarterly { get; } = new AlertTimeGrainType(QuarterlyValue);
        /// <summary> Annually. </summary>
        public static AlertTimeGrainType Annually { get; } = new AlertTimeGrainType(AnnuallyValue);
        /// <summary> BillingMonth. </summary>
        public static AlertTimeGrainType BillingMonth { get; } = new AlertTimeGrainType(BillingMonthValue);
        /// <summary> BillingQuarter. </summary>
        public static AlertTimeGrainType BillingQuarter { get; } = new AlertTimeGrainType(BillingQuarterValue);
        /// <summary> BillingAnnual. </summary>
        public static AlertTimeGrainType BillingAnnual { get; } = new AlertTimeGrainType(BillingAnnualValue);
        /// <summary> Determines if two <see cref="AlertTimeGrainType"/> values are the same. </summary>
        public static bool operator ==(AlertTimeGrainType left, AlertTimeGrainType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AlertTimeGrainType"/> values are not the same. </summary>
        public static bool operator !=(AlertTimeGrainType left, AlertTimeGrainType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AlertTimeGrainType"/>. </summary>
        public static implicit operator AlertTimeGrainType(string value) => new AlertTimeGrainType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AlertTimeGrainType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AlertTimeGrainType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
