// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Alert details. </summary>
    public partial class AlertPropertiesDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AlertPropertiesDetails"/>. </summary>
        public AlertPropertiesDetails()
        {
            ResourceGroupFilter = new ChangeTrackingList<BinaryData>();
            ResourceFilter = new ChangeTrackingList<BinaryData>();
            MeterFilter = new ChangeTrackingList<BinaryData>();
            ContactEmails = new ChangeTrackingList<string>();
            ContactGroups = new ChangeTrackingList<string>();
            ContactRoles = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AlertPropertiesDetails"/>. </summary>
        /// <param name="timeGrainType"> Type of timegrain cadence. </param>
        /// <param name="periodStartDate"> datetime of periodStartDate. </param>
        /// <param name="triggeredBy"> notificationId that triggered this alert. </param>
        /// <param name="resourceGroupFilter"> array of resourceGroups to filter by. </param>
        /// <param name="resourceFilter"> array of resources to filter by. </param>
        /// <param name="meterFilter"> array of meters to filter by. </param>
        /// <param name="tagFilter"> tags to filter by. </param>
        /// <param name="threshold"> notification threshold percentage as a decimal which activated this alert. </param>
        /// <param name="operator"> operator used to compare currentSpend with amount. </param>
        /// <param name="amount"> budget threshold amount. </param>
        /// <param name="unit"> unit of currency being used. </param>
        /// <param name="currentSpend"> current spend. </param>
        /// <param name="contactEmails"> list of emails to contact. </param>
        /// <param name="contactGroups"> list of action groups to broadcast to. </param>
        /// <param name="contactRoles"> list of contact roles. </param>
        /// <param name="overridingAlert"> overriding alert. </param>
        /// <param name="departmentName"> department name. </param>
        /// <param name="companyName"> company name. </param>
        /// <param name="enrollmentNumber"> enrollment number. </param>
        /// <param name="enrollmentStartDate"> datetime of enrollmentStartDate. </param>
        /// <param name="enrollmentEndDate"> datetime of enrollmentEndDate. </param>
        /// <param name="invoicingThreshold"> invoicing threshold. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AlertPropertiesDetails(AlertTimeGrainType? timeGrainType, string periodStartDate, string triggeredBy, IList<BinaryData> resourceGroupFilter, IList<BinaryData> resourceFilter, IList<BinaryData> meterFilter, BinaryData tagFilter, decimal? threshold, CostManagementAlertOperator? @operator, decimal? amount, string unit, decimal? currentSpend, IList<string> contactEmails, IList<string> contactGroups, IList<string> contactRoles, string overridingAlert, string departmentName, string companyName, string enrollmentNumber, string enrollmentStartDate, string enrollmentEndDate, decimal? invoicingThreshold, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TimeGrainType = timeGrainType;
            PeriodStartDate = periodStartDate;
            TriggeredBy = triggeredBy;
            ResourceGroupFilter = resourceGroupFilter;
            ResourceFilter = resourceFilter;
            MeterFilter = meterFilter;
            TagFilter = tagFilter;
            Threshold = threshold;
            Operator = @operator;
            Amount = amount;
            Unit = unit;
            CurrentSpend = currentSpend;
            ContactEmails = contactEmails;
            ContactGroups = contactGroups;
            ContactRoles = contactRoles;
            OverridingAlert = overridingAlert;
            DepartmentName = departmentName;
            CompanyName = companyName;
            EnrollmentNumber = enrollmentNumber;
            EnrollmentStartDate = enrollmentStartDate;
            EnrollmentEndDate = enrollmentEndDate;
            InvoicingThreshold = invoicingThreshold;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of timegrain cadence. </summary>
        public AlertTimeGrainType? TimeGrainType { get; set; }
        /// <summary> datetime of periodStartDate. </summary>
        public string PeriodStartDate { get; set; }
        /// <summary> notificationId that triggered this alert. </summary>
        public string TriggeredBy { get; set; }
        /// <summary>
        /// array of resourceGroups to filter by
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IList<BinaryData> ResourceGroupFilter { get; }
        /// <summary>
        /// array of resources to filter by
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IList<BinaryData> ResourceFilter { get; }
        /// <summary>
        /// array of meters to filter by
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IList<BinaryData> MeterFilter { get; }
        /// <summary>
        /// tags to filter by
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData TagFilter { get; set; }
        /// <summary> notification threshold percentage as a decimal which activated this alert. </summary>
        public decimal? Threshold { get; set; }
        /// <summary> operator used to compare currentSpend with amount. </summary>
        public CostManagementAlertOperator? Operator { get; set; }
        /// <summary> budget threshold amount. </summary>
        public decimal? Amount { get; set; }
        /// <summary> unit of currency being used. </summary>
        public string Unit { get; set; }
        /// <summary> current spend. </summary>
        public decimal? CurrentSpend { get; set; }
        /// <summary> list of emails to contact. </summary>
        public IList<string> ContactEmails { get; }
        /// <summary> list of action groups to broadcast to. </summary>
        public IList<string> ContactGroups { get; }
        /// <summary> list of contact roles. </summary>
        public IList<string> ContactRoles { get; }
        /// <summary> overriding alert. </summary>
        public string OverridingAlert { get; set; }
        /// <summary> department name. </summary>
        public string DepartmentName { get; set; }
        /// <summary> company name. </summary>
        public string CompanyName { get; set; }
        /// <summary> enrollment number. </summary>
        public string EnrollmentNumber { get; set; }
        /// <summary> datetime of enrollmentStartDate. </summary>
        public string EnrollmentStartDate { get; set; }
        /// <summary> datetime of enrollmentEndDate. </summary>
        public string EnrollmentEndDate { get; set; }
        /// <summary> invoicing threshold. </summary>
        public decimal? InvoicingThreshold { get; set; }
    }
}
