// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> defines the type of alert. </summary>
    public partial class AlertPropertiesDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AlertPropertiesDefinition"/>. </summary>
        public AlertPropertiesDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AlertPropertiesDefinition"/>. </summary>
        /// <param name="alertType"> type of alert. </param>
        /// <param name="category"> Alert category. </param>
        /// <param name="criteria"> Criteria that triggered alert. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AlertPropertiesDefinition(CostManagementAlertType? alertType, CostManagementAlertCategory? category, AlertCriterion? criteria, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AlertType = alertType;
            Category = category;
            Criteria = criteria;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> type of alert. </summary>
        public CostManagementAlertType? AlertType { get; set; }
        /// <summary> Alert category. </summary>
        public CostManagementAlertCategory? Category { get; set; }
        /// <summary> Criteria that triggered alert. </summary>
        public AlertCriterion? Criteria { get; set; }
    }
}
