// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Show costs accumulated over time. </summary>
    public readonly partial struct AccumulatedType : IEquatable<AccumulatedType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AccumulatedType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AccumulatedType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> true. </summary>
        public static AccumulatedType True { get; } = new AccumulatedType(TrueValue);
        /// <summary> false. </summary>
        public static AccumulatedType False { get; } = new AccumulatedType(FalseValue);
        /// <summary> Determines if two <see cref="AccumulatedType"/> values are the same. </summary>
        public static bool operator ==(AccumulatedType left, AccumulatedType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AccumulatedType"/> values are not the same. </summary>
        public static bool operator !=(AccumulatedType left, AccumulatedType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AccumulatedType"/>. </summary>
        public static implicit operator AccumulatedType(string value) => new AccumulatedType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AccumulatedType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AccumulatedType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
