// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.CostManagement.Models;

namespace Azure.ResourceManager.CostManagement
{
    internal class DownloadURLOperationSource : IOperationSource<DownloadURL>
    {
        DownloadURL IOperationSource<DownloadURL>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return DownloadURL.DeserializeDownloadURL(document.RootElement);
        }

        async ValueTask<DownloadURL> IOperationSource<DownloadURL>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return DownloadURL.DeserializeDownloadURL(document.RootElement);
        }
    }
}
