// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmCostManagementModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.BenefitRecommendationModel"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// The properties of the benefit recommendations.
        /// Please note <see cref="Models.BenefitRecommendationProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SharedScopeBenefitRecommendationProperties"/> and <see cref="Models.SingleScopeBenefitRecommendationProperties"/>.
        /// </param>
        /// <param name="kind"> Reservation or SavingsPlan. </param>
        /// <returns> A new <see cref="Models.BenefitRecommendationModel"/> instance for mocking. </returns>
        public static BenefitRecommendationModel BenefitRecommendationModel(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BenefitRecommendationProperties properties = null, BillingAccountBenefitKind? kind = null)
        {
            return new BenefitRecommendationModel(
                id,
                name,
                resourceType,
                systemData,
                properties,
                kind,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BenefitRecommendationProperties"/>. </summary>
        /// <param name="firstConsumptionOn"> The first usage date used for looking back for computing the recommendations. </param>
        /// <param name="lastConsumptionOn"> The last usage date used for looking back for computing the recommendations. </param>
        /// <param name="lookBackPeriod"> The number of days of usage evaluated for computing the recommendations. </param>
        /// <param name="totalHours"> The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'. </param>
        /// <param name="usage"> On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </param>
        /// <param name="armSkuName"> ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan. </param>
        /// <param name="term"> Term period of the benefit. For example, P1Y or P3Y. </param>
        /// <param name="commitmentGranularity"> Grain of the proposed commitment amount. Supported values: 'Hourly'. </param>
        /// <param name="currencyCode"> An ISO 4217 currency code identifier for the costs and savings amounts. </param>
        /// <param name="costWithoutBenefit"> The current cost without benefit, corresponds to 'totalHours' in the look-back period. </param>
        /// <param name="recommendationDetails"> The details of the proposed recommendation. </param>
        /// <param name="allRecommendationDetails"> The list of all benefit recommendations with the recommendation details. </param>
        /// <param name="scope"> Benefit scope. For example, Single or Shared. </param>
        /// <returns> A new <see cref="Models.BenefitRecommendationProperties"/> instance for mocking. </returns>
        public static BenefitRecommendationProperties BenefitRecommendationProperties(DateTimeOffset? firstConsumptionOn = null, DateTimeOffset? lastConsumptionOn = null, LookBackPeriod? lookBackPeriod = null, int? totalHours = null, RecommendationUsageDetails usage = null, string armSkuName = null, BenefitRecommendationPeriodTerm? term = null, BenefitRecommendationUsageGrain? commitmentGranularity = null, string currencyCode = null, decimal? costWithoutBenefit = null, AllSavingsBenefitDetails recommendationDetails = null, AllSavingsList allRecommendationDetails = null, string scope = null)
        {
            return new UnknownBenefitRecommendationProperties(
                firstConsumptionOn,
                lastConsumptionOn,
                lookBackPeriod,
                totalHours,
                usage,
                armSkuName,
                term,
                commitmentGranularity,
                currencyCode,
                costWithoutBenefit,
                recommendationDetails,
                allRecommendationDetails,
                scope == null ? default : new BenefitRecommendationScope(scope),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecommendationUsageDetails"/>. </summary>
        /// <param name="usageGrain"> The grain of the usage. Supported values: 'Hourly'. </param>
        /// <param name="charges"> On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </param>
        /// <returns> A new <see cref="Models.RecommendationUsageDetails"/> instance for mocking. </returns>
        public static RecommendationUsageDetails RecommendationUsageDetails(BenefitRecommendationUsageGrain? usageGrain = null, IEnumerable<decimal> charges = null)
        {
            charges ??= new List<decimal>();

            return new RecommendationUsageDetails(usageGrain, charges?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AllSavingsBenefitDetails"/>. </summary>
        /// <param name="overageCost"> The difference between total cost and benefit cost for the 'totalHours' in the look-back period. </param>
        /// <param name="benefitCost"> The estimated cost with benefit for the 'totalHours' in the look-back period. It's equal to (commitmentAmount * totalHours). </param>
        /// <param name="totalCost"> Total cost, which is sum of benefit cost and overage cost. </param>
        /// <param name="savingsAmount"> The amount saved for the 'totalHours' in the look-back period, by purchasing the recommended quantity of the benefit. </param>
        /// <param name="savingsPercentage"> The savings in percentage for the 'totalHours' in the look-back period, by purchasing the recommended quantity of benefit. </param>
        /// <param name="coveragePercentage"> Estimated benefit coverage percentage for the 'totalHours' in the look-back period, with this commitment. </param>
        /// <param name="commitmentAmount"> The commitment amount at the commitmentGranularity. </param>
        /// <param name="averageUtilizationPercentage"> Estimated average utilization percentage for the 'totalHours' in the look-back period, with this commitment. </param>
        /// <param name="wastageCost"> Estimated unused portion of the 'benefitCost'. </param>
        /// <returns> A new <see cref="Models.AllSavingsBenefitDetails"/> instance for mocking. </returns>
        public static AllSavingsBenefitDetails AllSavingsBenefitDetails(decimal? overageCost = null, decimal? benefitCost = null, decimal? totalCost = null, decimal? savingsAmount = null, decimal? savingsPercentage = null, decimal? coveragePercentage = null, decimal? commitmentAmount = null, decimal? averageUtilizationPercentage = null, decimal? wastageCost = null)
        {
            return new AllSavingsBenefitDetails(
                overageCost,
                benefitCost,
                totalCost,
                savingsAmount,
                savingsPercentage,
                coveragePercentage,
                commitmentAmount,
                averageUtilizationPercentage,
                wastageCost,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AllSavingsList"/>. </summary>
        /// <param name="value"> The list of benefit recommendations with the recommendation details.. </param>
        /// <param name="nextLink"> The link (URL) to the next page of results. </param>
        /// <returns> A new <see cref="Models.AllSavingsList"/> instance for mocking. </returns>
        public static AllSavingsList AllSavingsList(IEnumerable<AllSavingsBenefitDetails> value = null, Uri nextLink = null)
        {
            value ??= new List<AllSavingsBenefitDetails>();

            return new AllSavingsList(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExportRunErrorDetails"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message indicating why the operation failed. </param>
        /// <returns> A new <see cref="Models.ExportRunErrorDetails"/> instance for mocking. </returns>
        public static ExportRunErrorDetails ExportRunErrorDetails(string code = null, string message = null)
        {
            return new ExportRunErrorDetails(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BenefitUtilizationSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Supported values: 'SavingsPlan'. </param>
        /// <returns> A new <see cref="Models.BenefitUtilizationSummary"/> instance for mocking. </returns>
        public static BenefitUtilizationSummary BenefitUtilizationSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null)
        {
            return new BenefitUtilizationSummary(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new BillingAccountBenefitKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BenefitUtilizationSummariesOperationStatus"/>. </summary>
        /// <param name="input"> Input given to create the benefit utilization summaries report. </param>
        /// <param name="status"> The status of the creation of the benefit utilization summaries report. </param>
        /// <param name="properties"> Contains sas url to the async benefit utilization summaries report and a date that the url is valid until. These values will be empty if the report is in a Running or Failed state. </param>
        /// <returns> A new <see cref="Models.BenefitUtilizationSummariesOperationStatus"/> instance for mocking. </returns>
        public static BenefitUtilizationSummariesOperationStatus BenefitUtilizationSummariesOperationStatus(BenefitUtilizationSummariesContent input = null, OperationStatusType? status = null, AsyncOperationStatusProperties properties = null)
        {
            return new BenefitUtilizationSummariesOperationStatus(input, status, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AsyncOperationStatusProperties"/>. </summary>
        /// <param name="reportUri"> Sas url to the async benefit utilization summaries report. Will be empty if the report is in Running or Failed state. </param>
        /// <param name="secondaryReportUri"> Sas url to async benefit utilization summaries report in secondary storage in case of primary outage. Will be empty if the report is in Running or Failed state. </param>
        /// <param name="validUntil"> The date that the sas url provided in reportUrl expires. </param>
        /// <returns> A new <see cref="Models.AsyncOperationStatusProperties"/> instance for mocking. </returns>
        public static AsyncOperationStatusProperties AsyncOperationStatusProperties(BenefitUtilizationSummaryReportSchema? reportUri = null, BenefitUtilizationSummaryReportSchema? secondaryReportUri = null, DateTimeOffset? validUntil = null)
        {
            return new AsyncOperationStatusProperties(reportUri, secondaryReportUri, validUntil, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CostManagement.CostManagementExportData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="format"> The format of the export being delivered. Currently only 'Csv' is supported. </param>
        /// <param name="deliveryInfoDestination"> Has delivery information for the export. </param>
        /// <param name="definition"> Has the definition for the export. </param>
        /// <param name="runHistoryValue"> If requested, has the most recent run history for the export. </param>
        /// <param name="partitionData"> If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes. </param>
        /// <param name="nextRunTimeEstimate"> If the export has an active schedule, provides an estimate of the next run time. </param>
        /// <param name="schedule"> Has schedule information for the export. </param>
        /// <param name="eTag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="CostManagement.CostManagementExportData"/> instance for mocking. </returns>
        public static CostManagementExportData CostManagementExportData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExportFormatType? format = null, ExportDeliveryDestination deliveryInfoDestination = null, ExportDefinition definition = null, IEnumerable<ExportRun> runHistoryValue = null, bool? partitionData = null, DateTimeOffset? nextRunTimeEstimate = null, ExportSchedule schedule = null, ETag? eTag = null)
        {
            runHistoryValue ??= new List<ExportRun>();

            return new CostManagementExportData(
                id,
                name,
                resourceType,
                systemData,
                format,
                deliveryInfoDestination != null ? new ExportDeliveryInfo(deliveryInfoDestination, serializedAdditionalRawData: null) : null,
                definition,
                runHistoryValue != null ? new ExportExecutionListResult(runHistoryValue?.ToList(), serializedAdditionalRawData: null) : null,
                partitionData,
                nextRunTimeEstimate,
                schedule,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommonExportProperties"/>. </summary>
        /// <param name="format"> The format of the export being delivered. Currently only 'Csv' is supported. </param>
        /// <param name="deliveryInfoDestination"> Has delivery information for the export. </param>
        /// <param name="definition"> Has the definition for the export. </param>
        /// <param name="runHistoryValue"> If requested, has the most recent run history for the export. </param>
        /// <param name="partitionData"> If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes. </param>
        /// <param name="nextRunTimeEstimate"> If the export has an active schedule, provides an estimate of the next run time. </param>
        /// <returns> A new <see cref="Models.CommonExportProperties"/> instance for mocking. </returns>
        public static CommonExportProperties CommonExportProperties(ExportFormatType? format = null, ExportDeliveryDestination deliveryInfoDestination = null, ExportDefinition definition = null, IEnumerable<ExportRun> runHistoryValue = null, bool? partitionData = null, DateTimeOffset? nextRunTimeEstimate = null)
        {
            runHistoryValue ??= new List<ExportRun>();

            return new CommonExportProperties(
                format,
                deliveryInfoDestination != null ? new ExportDeliveryInfo(deliveryInfoDestination, serializedAdditionalRawData: null) : null,
                definition,
                runHistoryValue != null ? new ExportExecutionListResult(runHistoryValue?.ToList(), serializedAdditionalRawData: null) : null,
                partitionData,
                nextRunTimeEstimate,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExportRun"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="executionType"> The type of the export run. </param>
        /// <param name="status"> The last known status of the export run. </param>
        /// <param name="submittedBy"> The identifier for the entity that triggered the export. For on-demand runs it is the user email. For scheduled runs it is 'System'. </param>
        /// <param name="submittedOn"> The time when export was queued to be run. </param>
        /// <param name="processingStartOn"> The time when export was picked up to be run. </param>
        /// <param name="processingEndOn"> The time when the export run finished. </param>
        /// <param name="fileName"> The name of the exported file. </param>
        /// <param name="runSettings"> The export settings that were in effect for this run. </param>
        /// <param name="error"> The details of any error. </param>
        /// <param name="eTag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ExportRun"/> instance for mocking. </returns>
        public static ExportRun ExportRun(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExportRunExecutionType? executionType = null, ExportRunExecutionStatus? status = null, string submittedBy = null, DateTimeOffset? submittedOn = null, DateTimeOffset? processingStartOn = null, DateTimeOffset? processingEndOn = null, string fileName = null, CommonExportProperties runSettings = null, ExportRunErrorDetails error = null, ETag? eTag = null)
        {
            return new ExportRun(
                id,
                name,
                resourceType,
                systemData,
                executionType,
                status,
                submittedBy,
                submittedOn,
                processingStartOn,
                processingEndOn,
                fileName,
                runSettings,
                error,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CostManagement.CostManagementViewData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> User input name of the view. Required. </param>
        /// <param name="scope"> Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope. </param>
        /// <param name="createdOn"> Date the user created this view. </param>
        /// <param name="modifiedOn"> Date when the user last modified this view. </param>
        /// <param name="dateRange"> Date range of the current view. </param>
        /// <param name="currency"> Currency of the current view. </param>
        /// <param name="chart"> Chart type of the main view in Cost Analysis. Required. </param>
        /// <param name="accumulated"> Show costs accumulated over time. </param>
        /// <param name="metric"> Metric to use when displaying costs. </param>
        /// <param name="kpis"> List of KPIs to show in Cost Analysis UI. </param>
        /// <param name="pivots"> Configuration of 3 sub-views in the Cost Analysis UI. </param>
        /// <param name="typePropertiesQueryType"> The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates. </param>
        /// <param name="timeframe"> The time frame for pulling data for the report. If custom, then a specific time period must be provided. </param>
        /// <param name="timePeriod"> Has time period for pulling data for the report. </param>
        /// <param name="dataSet"> Has definition for data in this report config. </param>
        /// <param name="includeMonetaryCommitment"> If true, report includes monetary commitment. </param>
        /// <param name="eTag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="CostManagement.CostManagementViewData"/> instance for mocking. </returns>
        public static CostManagementViewData CostManagementViewData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string displayName = null, ResourceIdentifier scope = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, string dateRange = null, string currency = null, ViewChartType? chart = null, AccumulatedType? accumulated = null, ViewMetricType? metric = null, IEnumerable<ViewKpiProperties> kpis = null, IEnumerable<ViewPivotProperties> pivots = null, ViewReportType? typePropertiesQueryType = null, ReportTimeframeType? timeframe = null, ReportConfigTimePeriod timePeriod = null, ReportConfigDataset dataSet = null, bool? includeMonetaryCommitment = null, ETag? eTag = null)
        {
            kpis ??= new List<ViewKpiProperties>();
            pivots ??= new List<ViewPivotProperties>();

            return new CostManagementViewData(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                scope,
                createdOn,
                modifiedOn,
                dateRange,
                currency,
                chart,
                accumulated,
                metric,
                kpis?.ToList(),
                pivots?.ToList(),
                typePropertiesQueryType,
                timeframe,
                timePeriod,
                dataSet,
                includeMonetaryCommitment,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CostManagement.CostManagementAlertData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="definition"> defines the type of alert. </param>
        /// <param name="description"> Alert description. </param>
        /// <param name="source"> Source of alert. </param>
        /// <param name="details"> Alert details. </param>
        /// <param name="costEntityId"> related budget. </param>
        /// <param name="status"> alert status. </param>
        /// <param name="createdOn"> dateTime in which alert was created. </param>
        /// <param name="closeOn"> dateTime in which alert was closed. </param>
        /// <param name="modifiedOn"> dateTime in which alert was last modified. </param>
        /// <param name="statusModificationUserName"> User who last modified the alert. </param>
        /// <param name="statusModifiedOn"> dateTime in which the alert status was last modified. </param>
        /// <param name="eTag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="CostManagement.CostManagementAlertData"/> instance for mocking. </returns>
        public static CostManagementAlertData CostManagementAlertData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AlertPropertiesDefinition definition = null, string description = null, CostManagementAlertSource? source = null, AlertPropertiesDetails details = null, string costEntityId = null, CostManagementAlertStatus? status = null, DateTimeOffset? createdOn = null, DateTimeOffset? closeOn = null, DateTimeOffset? modifiedOn = null, string statusModificationUserName = null, DateTimeOffset? statusModifiedOn = null, ETag? eTag = null)
        {
            return new CostManagementAlertData(
                id,
                name,
                resourceType,
                systemData,
                definition,
                description,
                source,
                details,
                costEntityId,
                status,
                createdOn,
                closeOn,
                modifiedOn,
                statusModificationUserName,
                statusModifiedOn,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ForecastDefinition"/>. </summary>
        /// <param name="forecastType"> The type of the forecast. </param>
        /// <param name="timeframe"> The time frame for pulling data for the forecast. If custom, then a specific time period must be provided. </param>
        /// <param name="timePeriod"> Has time period for pulling data for the forecast. </param>
        /// <param name="dataset"> Has definition for data in this forecast. </param>
        /// <param name="includeActualCost"> A boolean determining if actualCost will be included. </param>
        /// <param name="includeFreshPartialCost"> A boolean determining if FreshPartialCost will be included. </param>
        /// <returns> A new <see cref="Models.ForecastDefinition"/> instance for mocking. </returns>
        public static ForecastDefinition ForecastDefinition(ForecastType forecastType = default, ForecastTimeframe timeframe = default, ForecastTimePeriod timePeriod = null, ForecastDataset dataset = null, bool? includeActualCost = null, bool? includeFreshPartialCost = null)
        {
            return new ForecastDefinition(
                forecastType,
                timeframe,
                timePeriod,
                dataset,
                includeActualCost,
                includeFreshPartialCost,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ForecastResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="columns"> Array of columns. </param>
        /// <param name="rows"> Array of rows. </param>
        /// <param name="location"> Location of the resource. </param>
        /// <param name="sku"> SKU of the resource. </param>
        /// <param name="eTag"> ETag of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ForecastResult"/> instance for mocking. </returns>
        public static ForecastResult ForecastResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string nextLink = null, IEnumerable<ForecastColumn> columns = null, IEnumerable<IList<BinaryData>> rows = null, AzureLocation? location = null, string sku = null, ETag? eTag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            columns ??= new List<ForecastColumn>();
            rows ??= new List<IList<BinaryData>>();
            tags ??= new Dictionary<string, string>();

            return new ForecastResult(
                id,
                name,
                resourceType,
                systemData,
                nextLink,
                columns?.ToList(),
                rows?.ToList(),
                location,
                sku,
                eTag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ForecastColumn"/>. </summary>
        /// <param name="name"> The name of column. </param>
        /// <param name="forecastColumnType"> The type of column. </param>
        /// <returns> A new <see cref="Models.ForecastColumn"/> instance for mocking. </returns>
        public static ForecastColumn ForecastColumn(string name = null, string forecastColumnType = null)
        {
            return new ForecastColumn(name, forecastColumnType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CostManagementDimension"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Dimension description. </param>
        /// <param name="isFilterEnabled"> Filter enabled. </param>
        /// <param name="isGroupingEnabled"> Grouping enabled. </param>
        /// <param name="data"> Dimension data. </param>
        /// <param name="total"> Total number of data for the dimension. </param>
        /// <param name="category"> Dimension category. </param>
        /// <param name="usageStart"> Usage start. </param>
        /// <param name="usageEnd"> Usage end. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="location"> Location of the resource. </param>
        /// <param name="sku"> SKU of the resource. </param>
        /// <param name="eTag"> ETag of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.CostManagementDimension"/> instance for mocking. </returns>
        public static CostManagementDimension CostManagementDimension(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, bool? isFilterEnabled = null, bool? isGroupingEnabled = null, IEnumerable<string> data = null, int? total = null, string category = null, DateTimeOffset? usageStart = null, DateTimeOffset? usageEnd = null, string nextLink = null, AzureLocation? location = null, string sku = null, ETag? eTag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            data ??= new List<string>();
            tags ??= new Dictionary<string, string>();

            return new CostManagementDimension(
                id,
                name,
                resourceType,
                systemData,
                description,
                isFilterEnabled,
                isGroupingEnabled,
                data?.ToList(),
                total,
                category,
                usageStart,
                usageEnd,
                nextLink,
                location,
                sku,
                eTag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QueryDefinition"/>. </summary>
        /// <param name="exportType"> The type of the query. </param>
        /// <param name="timeframe"> The time frame for pulling data for the query. If custom, then a specific time period must be provided. </param>
        /// <param name="timePeriod"> Has time period for pulling data for the query. </param>
        /// <param name="dataset"> Has definition for data in this query. </param>
        /// <returns> A new <see cref="Models.QueryDefinition"/> instance for mocking. </returns>
        public static QueryDefinition QueryDefinition(ExportType exportType = default, TimeframeType timeframe = default, QueryTimePeriod timePeriod = null, QueryDataset dataset = null)
        {
            return new QueryDefinition(exportType, timeframe, timePeriod, dataset, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QueryResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="columns"> Array of columns. </param>
        /// <param name="rows"> Array of rows. </param>
        /// <param name="location"> Location of the resource. </param>
        /// <param name="sku"> SKU of the resource. </param>
        /// <param name="eTag"> ETag of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.QueryResult"/> instance for mocking. </returns>
        public static QueryResult QueryResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string nextLink = null, IEnumerable<QueryColumn> columns = null, IEnumerable<IList<BinaryData>> rows = null, AzureLocation? location = null, string sku = null, ETag? eTag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            columns ??= new List<QueryColumn>();
            rows ??= new List<IList<BinaryData>>();
            tags ??= new Dictionary<string, string>();

            return new QueryResult(
                id,
                name,
                resourceType,
                systemData,
                nextLink,
                columns?.ToList(),
                rows?.ToList(),
                location,
                sku,
                eTag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QueryColumn"/>. </summary>
        /// <param name="name"> The name of column. </param>
        /// <param name="queryColumnType"> The type of column. </param>
        /// <returns> A new <see cref="Models.QueryColumn"/> instance for mocking. </returns>
        public static QueryColumn QueryColumn(string name = null, string queryColumnType = null)
        {
            return new QueryColumn(name, queryColumnType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationStatus"/>. </summary>
        /// <param name="status"> The status of the long running operation. </param>
        /// <param name="reportUri"> The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity. </param>
        /// <param name="validUntil"> The time at which report URL becomes invalid. </param>
        /// <returns> A new <see cref="Models.OperationStatus"/> instance for mocking. </returns>
        public static OperationStatus OperationStatus(OperationStatusType? status = null, ReservationReportSchema? reportUri = null, DateTimeOffset? validUntil = null)
        {
            return new OperationStatus(status, reportUri, validUntil, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DownloadURL"/>. </summary>
        /// <param name="expiryOn"> The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z. </param>
        /// <param name="validTill"> The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z. </param>
        /// <param name="downloadUri"> The URL to download the generated report. </param>
        /// <returns> A new <see cref="Models.DownloadURL"/> instance for mocking. </returns>
        public static DownloadURL DownloadURL(DateTimeOffset? expiryOn = null, DateTimeOffset? validTill = null, Uri downloadUri = null)
        {
            return new DownloadURL(expiryOn, validTill, downloadUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CostManagement.ScheduledActionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Scheduled action name. </param>
        /// <param name="fileFormats"> Destination format of the view data. This is optional. </param>
        /// <param name="notification"> Notification properties based on scheduled action kind. </param>
        /// <param name="notificationEmail"> Email address of the point of contact that should get the unsubscribe requests and notification emails. </param>
        /// <param name="schedule"> Schedule of the scheduled action. </param>
        /// <param name="scope"> Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope. </param>
        /// <param name="status"> Status of the scheduled action. </param>
        /// <param name="viewId"> Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'. </param>
        /// <param name="eTag"> Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then including the latest eTag as part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not required. </param>
        /// <param name="kind"> Kind of the scheduled action. </param>
        /// <returns> A new <see cref="CostManagement.ScheduledActionData"/> instance for mocking. </returns>
        public static ScheduledActionData ScheduledActionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string displayName = null, IEnumerable<ScheduledActionFileFormat> fileFormats = null, NotificationProperties notification = null, string notificationEmail = null, ScheduleProperties schedule = null, ResourceIdentifier scope = null, ScheduledActionStatus? status = null, ResourceIdentifier viewId = null, ETag? eTag = null, ScheduledActionKind? kind = null)
        {
            fileFormats ??= new List<ScheduledActionFileFormat>();

            return new ScheduledActionData(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                fileFormats != null ? new FileDestination(fileFormats?.ToList(), serializedAdditionalRawData: null) : null,
                notification,
                notificationEmail,
                schedule,
                scope,
                status,
                viewId,
                eTag,
                kind,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CostManagementNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is available. </param>
        /// <returns> A new <see cref="Models.CostManagementNameAvailabilityResult"/> instance for mocking. </returns>
        public static CostManagementNameAvailabilityResult CostManagementNameAvailabilityResult(bool? nameAvailable = null, CostManagementUnavailabilityReason? reason = null, string message = null)
        {
            return new CostManagementNameAvailabilityResult(nameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SingleScopeBenefitRecommendationProperties"/>. </summary>
        /// <param name="firstConsumptionOn"> The first usage date used for looking back for computing the recommendations. </param>
        /// <param name="lastConsumptionOn"> The last usage date used for looking back for computing the recommendations. </param>
        /// <param name="lookBackPeriod"> The number of days of usage evaluated for computing the recommendations. </param>
        /// <param name="totalHours"> The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'. </param>
        /// <param name="usage"> On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </param>
        /// <param name="armSkuName"> ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan. </param>
        /// <param name="term"> Term period of the benefit. For example, P1Y or P3Y. </param>
        /// <param name="commitmentGranularity"> Grain of the proposed commitment amount. Supported values: 'Hourly'. </param>
        /// <param name="currencyCode"> An ISO 4217 currency code identifier for the costs and savings amounts. </param>
        /// <param name="costWithoutBenefit"> The current cost without benefit, corresponds to 'totalHours' in the look-back period. </param>
        /// <param name="recommendationDetails"> The details of the proposed recommendation. </param>
        /// <param name="allRecommendationDetails"> The list of all benefit recommendations with the recommendation details. </param>
        /// <param name="subscriptionId"> The subscription ID that this single scope recommendation is for. Applicable only if recommendation is for 'Single' scope. </param>
        /// <param name="resourceGroup"> The resource group that this single scope recommendation is for. Applicable only if recommendation is for 'Single' scope and 'ResourceGroup' request scope. </param>
        /// <returns> A new <see cref="Models.SingleScopeBenefitRecommendationProperties"/> instance for mocking. </returns>
        public static SingleScopeBenefitRecommendationProperties SingleScopeBenefitRecommendationProperties(DateTimeOffset? firstConsumptionOn = null, DateTimeOffset? lastConsumptionOn = null, LookBackPeriod? lookBackPeriod = null, int? totalHours = null, RecommendationUsageDetails usage = null, string armSkuName = null, BenefitRecommendationPeriodTerm? term = null, BenefitRecommendationUsageGrain? commitmentGranularity = null, string currencyCode = null, decimal? costWithoutBenefit = null, AllSavingsBenefitDetails recommendationDetails = null, AllSavingsList allRecommendationDetails = null, string subscriptionId = null, string resourceGroup = null)
        {
            return new SingleScopeBenefitRecommendationProperties(
                firstConsumptionOn,
                lastConsumptionOn,
                lookBackPeriod,
                totalHours,
                usage,
                armSkuName,
                term,
                commitmentGranularity,
                currencyCode,
                costWithoutBenefit,
                recommendationDetails,
                allRecommendationDetails,
                BenefitRecommendationScope.Single,
                serializedAdditionalRawData: null,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SharedScopeBenefitRecommendationProperties"/>. </summary>
        /// <param name="firstConsumptionOn"> The first usage date used for looking back for computing the recommendations. </param>
        /// <param name="lastConsumptionOn"> The last usage date used for looking back for computing the recommendations. </param>
        /// <param name="lookBackPeriod"> The number of days of usage evaluated for computing the recommendations. </param>
        /// <param name="totalHours"> The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'. </param>
        /// <param name="usage"> On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </param>
        /// <param name="armSkuName"> ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan. </param>
        /// <param name="term"> Term period of the benefit. For example, P1Y or P3Y. </param>
        /// <param name="commitmentGranularity"> Grain of the proposed commitment amount. Supported values: 'Hourly'. </param>
        /// <param name="currencyCode"> An ISO 4217 currency code identifier for the costs and savings amounts. </param>
        /// <param name="costWithoutBenefit"> The current cost without benefit, corresponds to 'totalHours' in the look-back period. </param>
        /// <param name="recommendationDetails"> The details of the proposed recommendation. </param>
        /// <param name="allRecommendationDetails"> The list of all benefit recommendations with the recommendation details. </param>
        /// <returns> A new <see cref="Models.SharedScopeBenefitRecommendationProperties"/> instance for mocking. </returns>
        public static SharedScopeBenefitRecommendationProperties SharedScopeBenefitRecommendationProperties(DateTimeOffset? firstConsumptionOn = null, DateTimeOffset? lastConsumptionOn = null, LookBackPeriod? lookBackPeriod = null, int? totalHours = null, RecommendationUsageDetails usage = null, string armSkuName = null, BenefitRecommendationPeriodTerm? term = null, BenefitRecommendationUsageGrain? commitmentGranularity = null, string currencyCode = null, decimal? costWithoutBenefit = null, AllSavingsBenefitDetails recommendationDetails = null, AllSavingsList allRecommendationDetails = null)
        {
            return new SharedScopeBenefitRecommendationProperties(
                firstConsumptionOn,
                lastConsumptionOn,
                lookBackPeriod,
                totalHours,
                usage,
                armSkuName,
                term,
                commitmentGranularity,
                currencyCode,
                costWithoutBenefit,
                recommendationDetails,
                allRecommendationDetails,
                BenefitRecommendationScope.Shared,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IncludedQuantityUtilizationSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="armSkuName"> ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan. </param>
        /// <param name="benefitId"> The benefit ID is the identifier of the benefit. </param>
        /// <param name="benefitOrderId"> The benefit order ID is the identifier for a benefit purchase. </param>
        /// <param name="benefitType"> The benefit type. Supported values: 'SavingsPlan'. </param>
        /// <param name="usageOn"> Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field will be first day of the month. </param>
        /// <param name="utilizationPercentage"> This is the utilized percentage for the benefit ID. </param>
        /// <returns> A new <see cref="Models.IncludedQuantityUtilizationSummary"/> instance for mocking. </returns>
        public static IncludedQuantityUtilizationSummary IncludedQuantityUtilizationSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string armSkuName = null, string benefitId = null, string benefitOrderId = null, BillingAccountBenefitKind? benefitType = null, DateTimeOffset? usageOn = null, decimal? utilizationPercentage = null)
        {
            return new IncludedQuantityUtilizationSummary(
                id,
                name,
                resourceType,
                systemData,
                BillingAccountBenefitKind.IncludedQuantity,
                serializedAdditionalRawData: null,
                armSkuName,
                benefitId,
                benefitOrderId,
                benefitType,
                usageOn,
                utilizationPercentage);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SavingsPlanUtilizationSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="armSkuName"> ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan. </param>
        /// <param name="benefitId"> The benefit ID is the identifier of the benefit. </param>
        /// <param name="benefitOrderId"> The benefit order ID is the identifier for a benefit purchase. </param>
        /// <param name="benefitType"> The benefit type. Supported values: 'SavingsPlan'. </param>
        /// <param name="usageOn"> Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field will be first day of the month. </param>
        /// <param name="avgUtilizationPercentage"> This is the average hourly utilization for each date range that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate &gt; 2023-03-01 and usageDate &lt; 2022-10-31 at a daily granularity. There will be one record per benefit id for each day. For a single day, the avgUtilizationPercentage value will be equal to the average of the set of values where the set contains 24 utilization percentage entries one for each hour in a specific day. </param>
        /// <param name="minUtilizationPercentage"> This is the minimum hourly utilization for each date range that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate &gt; 2023-03-01 and usageDate &lt; 2022-10-31 at a daily granularity. There will be one record per benefit id for each day. For a single day, the minUtilizationPercentage value will be equal to the smallest in the set of values where the set contains 24 utilization percentage entries one for each hour in a specific day. If on the day 2022-10-18, the lowest utilization percentage was 10% at hour 4, then the value for the minUtilizationPercentage in the response will be 10%. </param>
        /// <param name="maxUtilizationPercentage"> This is the maximum hourly utilization for each date range that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate &gt; 2023-03-01 and usageDate &lt; 2022-10-31 at a daily granularity. There will be one record per benefit id for each day. For a single day, the maxUtilizationPercentage value will be equal to the largest in the set of values where the set contains 24 utilization percentage entries one for each hour in a specific day. If on the day 2022-10-18, the largest utilization percentage was 90% at hour 5, then the value for the maxUtilizationPercentage in the response will be 90%. </param>
        /// <returns> A new <see cref="Models.SavingsPlanUtilizationSummary"/> instance for mocking. </returns>
        public static SavingsPlanUtilizationSummary SavingsPlanUtilizationSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string armSkuName = null, string benefitId = null, string benefitOrderId = null, BillingAccountBenefitKind? benefitType = null, DateTimeOffset? usageOn = null, decimal? avgUtilizationPercentage = null, decimal? minUtilizationPercentage = null, decimal? maxUtilizationPercentage = null)
        {
            return new SavingsPlanUtilizationSummary(
                id,
                name,
                resourceType,
                systemData,
                BillingAccountBenefitKind.SavingsPlan,
                serializedAdditionalRawData: null,
                armSkuName,
                benefitId,
                benefitOrderId,
                benefitType,
                usageOn,
                avgUtilizationPercentage,
                minUtilizationPercentage,
                maxUtilizationPercentage);
        }
    }
}
