// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CostManagement.Models;

namespace Azure.ResourceManager.CostManagement.Samples
{
    public partial class Sample_CostManagementViewsResource
    {
        // ResourceGroupView
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ResourceGroupView()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ViewByResourceGroup.json
            // this example is just showing the usage of "Views_GetByScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementViewsResource created on azure
            // for more information of creating CostManagementViewsResource, please refer to the document of CostManagementViewsResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string viewName = "swaggerExample";
            ResourceIdentifier costManagementViewsResourceId = CostManagementViewsResource.CreateResourceIdentifier(scope, viewName);
            CostManagementViewsResource costManagementViews = client.GetCostManagementViewsResource(costManagementViewsResourceId);

            // invoke the operation
            CostManagementViewsResource result = await costManagementViews.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementViewData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ResourceGroupCreateOrUpdateView
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ResourceGroupCreateOrUpdateView()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ViewCreateOrUpdateByResourceGroup.json
            // this example is just showing the usage of "Views_CreateOrUpdateByScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementViewsResource created on azure
            // for more information of creating CostManagementViewsResource, please refer to the document of CostManagementViewsResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string viewName = "swaggerExample";
            ResourceIdentifier costManagementViewsResourceId = CostManagementViewsResource.CreateResourceIdentifier(scope, viewName);
            CostManagementViewsResource costManagementViews = client.GetCostManagementViewsResource(costManagementViewsResourceId);

            // invoke the operation
            CostManagementViewData data = new CostManagementViewData()
            {
                DisplayName = "swagger Example",
                Chart = ViewChartType.Table,
                Accumulated = AccumulatedType.True,
                Metric = ViewMetricType.ActualCost,
                Kpis =
{
new ViewKpiProperties()
{
KpiType = ViewKpiType.Forecast,
Id = null,
IsEnabled = true,
},new ViewKpiProperties()
{
KpiType = ViewKpiType.Budget,
Id = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo"),
IsEnabled = true,
}
},
                Pivots =
{
new ViewPivotProperties()
{
PivotType = ViewPivotType.Dimension,
Name = "ServiceName",
},new ViewPivotProperties()
{
PivotType = ViewPivotType.Dimension,
Name = "MeterCategory",
},new ViewPivotProperties()
{
PivotType = ViewPivotType.TagKey,
Name = "swaggerTagKey",
}
},
                TypePropertiesQueryType = ViewReportType.Usage,
                Timeframe = ReportTimeframeType.MonthToDate,
                DataSet = new ReportConfigDataset()
                {
                    Granularity = ReportGranularityType.Daily,
                    Aggregation =
{
["totalCost"] = new ReportConfigAggregation("PreTaxCost",FunctionType.Sum),
},
                    Grouping =
{
},
                    Sorting =
{
new ReportConfigSorting("UsageDate")
{
Direction = ReportConfigSortingType.Ascending,
}
},
                },
                ETag = new ETag("\"1d4ff9fe66f1d10\""),
            };
            ArmOperation<CostManagementViewsResource> lro = await costManagementViews.UpdateAsync(WaitUntil.Completed, data);
            CostManagementViewsResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementViewData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ResourceGroupDeleteView
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ResourceGroupDeleteView()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ViewDeleteByResourceGroup.json
            // this example is just showing the usage of "Views_DeleteByScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementViewsResource created on azure
            // for more information of creating CostManagementViewsResource, please refer to the document of CostManagementViewsResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string viewName = "TestView";
            ResourceIdentifier costManagementViewsResourceId = CostManagementViewsResource.CreateResourceIdentifier(scope, viewName);
            CostManagementViewsResource costManagementViews = client.GetCostManagementViewsResource(costManagementViewsResourceId);

            // invoke the operation
            await costManagementViews.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
