// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CostManagement.Models;

namespace Azure.ResourceManager.CostManagement.Samples
{
    public partial class Sample_CostManagementExportResource
    {
        // ExportGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetByBillingAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetByBillingAccount.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/123456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportGetByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetByDepartment()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetByDepartment.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportGetByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetByEnrollmentAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetByEnrollmentAccount.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportGetByManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetByManagementGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetByManagementGroup.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Management/managementGroups/TestMG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportGetByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetByResourceGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetByResourceGroup.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportGetBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ExportGetBySubscription()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportGetBySubscription.json
            // this example is just showing the usage of "Exports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportResource result = await costManagementExport.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateByBillingAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateByBillingAccount.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/123456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateByDepartment()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateByDepartment.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateByEnrollmentAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateByEnrollmentAccount.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateByManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateByManagementGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateByManagementGroup.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Management/managementGroups/TestMG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateByResourceGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateByResourceGroup.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportCreateOrUpdateBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ExportCreateOrUpdateBySubscription()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportCreateOrUpdateBySubscription.json
            // this example is just showing the usage of "Exports_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            CostManagementExportData data = new CostManagementExportData()
            {
                Format = ExportFormatType.Csv,
                DeliveryInfoDestination = new ExportDeliveryDestination("exports")
                {
                    ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
                    RootFolderPath = "ad-hoc",
                },
                Definition = new ExportDefinition(ExportType.ActualCost, TimeframeType.MonthToDate)
                {
                    DataSet = new ExportDataset()
                    {
                        Granularity = GranularityType.Daily,
                        Columns =
{
"Date","MeterId","ResourceId","ResourceLocation","Quantity"
},
                    },
                },
                Schedule = new ExportSchedule()
                {
                    Status = ExportScheduleStatusType.Active,
                    Recurrence = ExportScheduleRecurrenceType.Weekly,
                    RecurrencePeriod = new ExportRecurrencePeriod(DateTimeOffset.Parse("2020-06-01T00:00:00Z"))
                    {
                        To = DateTimeOffset.Parse("2020-10-31T00:00:00Z"),
                    },
                },
            };
            ArmOperation<CostManagementExportResource> lro = await costManagementExport.UpdateAsync(WaitUntil.Completed, data);
            CostManagementExportResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CostManagementExportData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ExportDeleteByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteByBillingAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteByBillingAccount.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/123456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportDeleteByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteByDepartment()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteByDepartment.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportDeleteByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteByEnrollmentAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteByEnrollmentAccount.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportDeleteByManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteByManagementGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteByManagementGroup.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Management/managementGroups/TestMG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportDeleteByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteByResourceGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteByResourceGroup.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportDeleteBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ExportDeleteBySubscription()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportDeleteBySubscription.json
            // this example is just showing the usage of "Exports_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ExportRunByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunByBillingAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunByBillingAccount.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/123456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunByDepartment()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunByDepartment.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunByEnrollmentAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunByEnrollmentAccount.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunByManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunByManagementGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunByManagementGroup.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Management/managementGroups/TestMG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunByResourceGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunByResourceGroup.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Execute_ExportRunBySubscription()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunBySubscription.json
            // this example is just showing the usage of "Exports_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation
            await costManagementExport.ExecuteAsync();

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetByBillingAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetByBillingAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetByBillingAccount.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/123456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetByDepartment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetByDepartment()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetByDepartment.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetByEnrollmentAccount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetByEnrollmentAccount()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetByEnrollmentAccount.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetByManagementGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetByManagementGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetByManagementGroup.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "providers/Microsoft.Management/managementGroups/TestMG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetByResourceGroup()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetByResourceGroup.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportRunHistoryGetBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionHistory_ExportRunHistoryGetBySubscription()
        {
            // Generated from example definition: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2023-03-01/examples/ExportRunHistoryGetBySubscription.json
            // this example is just showing the usage of "Exports_GetExecutionHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CostManagementExportResource created on azure
            // for more information of creating CostManagementExportResource, please refer to the document of CostManagementExportResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string exportName = "TestExport";
            ResourceIdentifier costManagementExportResourceId = CostManagementExportResource.CreateResourceIdentifier(scope, exportName);
            CostManagementExportResource costManagementExport = client.GetCostManagementExportResource(costManagementExportResourceId);

            // invoke the operation and iterate over the result
            await foreach (ExportRun item in costManagementExport.GetExecutionHistoryAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
