// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Models
{
    /// <summary> The role of a server. </summary>
    public readonly partial struct CosmosDBForPostgreSqlServerRole : IEquatable<CosmosDBForPostgreSqlServerRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBForPostgreSqlServerRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBForPostgreSqlServerRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CoordinatorValue = "Coordinator";
        private const string WorkerValue = "Worker";

        /// <summary> Coordinator. </summary>
        public static CosmosDBForPostgreSqlServerRole Coordinator { get; } = new CosmosDBForPostgreSqlServerRole(CoordinatorValue);
        /// <summary> Worker. </summary>
        public static CosmosDBForPostgreSqlServerRole Worker { get; } = new CosmosDBForPostgreSqlServerRole(WorkerValue);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlServerRole"/> values are the same. </summary>
        public static bool operator ==(CosmosDBForPostgreSqlServerRole left, CosmosDBForPostgreSqlServerRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlServerRole"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBForPostgreSqlServerRole left, CosmosDBForPostgreSqlServerRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBForPostgreSqlServerRole"/>. </summary>
        public static implicit operator CosmosDBForPostgreSqlServerRole(string value) => new CosmosDBForPostgreSqlServerRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBForPostgreSqlServerRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBForPostgreSqlServerRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
