// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct CosmosDBForPostgreSqlProvisioningState : IEquatable<CosmosDBForPostgreSqlProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBForPostgreSqlProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBForPostgreSqlProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static CosmosDBForPostgreSqlProvisioningState Succeeded { get; } = new CosmosDBForPostgreSqlProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static CosmosDBForPostgreSqlProvisioningState Canceled { get; } = new CosmosDBForPostgreSqlProvisioningState(CanceledValue);
        /// <summary> InProgress. </summary>
        public static CosmosDBForPostgreSqlProvisioningState InProgress { get; } = new CosmosDBForPostgreSqlProvisioningState(InProgressValue);
        /// <summary> Failed. </summary>
        public static CosmosDBForPostgreSqlProvisioningState Failed { get; } = new CosmosDBForPostgreSqlProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CosmosDBForPostgreSqlProvisioningState left, CosmosDBForPostgreSqlProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBForPostgreSqlProvisioningState left, CosmosDBForPostgreSqlProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBForPostgreSqlProvisioningState"/>. </summary>
        public static implicit operator CosmosDBForPostgreSqlProvisioningState(string value) => new CosmosDBForPostgreSqlProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBForPostgreSqlProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBForPostgreSqlProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
