// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus : IEquatable<CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";

        /// <summary> Pending. </summary>
        public static CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus Pending { get; } = new CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus Approved { get; } = new CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus Rejected { get; } = new CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus left, CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus left, CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(string value) => new CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBForPostgreSqlPrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
