// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Models
{
    /// <summary> Data type of the configuration. </summary>
    public readonly partial struct CosmosDBForPostgreSqlConfigurationDataType : IEquatable<CosmosDBForPostgreSqlConfigurationDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBForPostgreSqlConfigurationDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBForPostgreSqlConfigurationDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BooleanValue = "Boolean";
        private const string NumericValue = "Numeric";
        private const string IntegerValue = "Integer";
        private const string EnumerationValue = "Enumeration";

        /// <summary> Boolean. </summary>
        public static CosmosDBForPostgreSqlConfigurationDataType Boolean { get; } = new CosmosDBForPostgreSqlConfigurationDataType(BooleanValue);
        /// <summary> Numeric. </summary>
        public static CosmosDBForPostgreSqlConfigurationDataType Numeric { get; } = new CosmosDBForPostgreSqlConfigurationDataType(NumericValue);
        /// <summary> Integer. </summary>
        public static CosmosDBForPostgreSqlConfigurationDataType Integer { get; } = new CosmosDBForPostgreSqlConfigurationDataType(IntegerValue);
        /// <summary> Enumeration. </summary>
        public static CosmosDBForPostgreSqlConfigurationDataType Enumeration { get; } = new CosmosDBForPostgreSqlConfigurationDataType(EnumerationValue);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlConfigurationDataType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBForPostgreSqlConfigurationDataType left, CosmosDBForPostgreSqlConfigurationDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBForPostgreSqlConfigurationDataType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBForPostgreSqlConfigurationDataType left, CosmosDBForPostgreSqlConfigurationDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBForPostgreSqlConfigurationDataType"/>. </summary>
        public static implicit operator CosmosDBForPostgreSqlConfigurationDataType(string value) => new CosmosDBForPostgreSqlConfigurationDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBForPostgreSqlConfigurationDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBForPostgreSqlConfigurationDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
