// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDBForPostgreSql
{
    internal class CosmosDBForPostgreSqlCoordinatorConfigurationOperationSource : IOperationSource<CosmosDBForPostgreSqlCoordinatorConfigurationResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBForPostgreSqlCoordinatorConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBForPostgreSqlCoordinatorConfigurationResource IOperationSource<CosmosDBForPostgreSqlCoordinatorConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBForPostgreSqlServerConfigurationData.DeserializeCosmosDBForPostgreSqlServerConfigurationData(document.RootElement);
            return new CosmosDBForPostgreSqlCoordinatorConfigurationResource(_client, data);
        }

        async ValueTask<CosmosDBForPostgreSqlCoordinatorConfigurationResource> IOperationSource<CosmosDBForPostgreSqlCoordinatorConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBForPostgreSqlServerConfigurationData.DeserializeCosmosDBForPostgreSqlServerConfigurationData(document.RootElement);
            return new CosmosDBForPostgreSqlCoordinatorConfigurationResource(_client, data);
        }
    }
}
