// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDBForPostgreSql
{
    internal class CosmosDBForPostgreSqlClusterOperationSource : IOperationSource<CosmosDBForPostgreSqlClusterResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBForPostgreSqlClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBForPostgreSqlClusterResource IOperationSource<CosmosDBForPostgreSqlClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBForPostgreSqlClusterData.DeserializeCosmosDBForPostgreSqlClusterData(document.RootElement);
            return new CosmosDBForPostgreSqlClusterResource(_client, data);
        }

        async ValueTask<CosmosDBForPostgreSqlClusterResource> IOperationSource<CosmosDBForPostgreSqlClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBForPostgreSqlClusterData.DeserializeCosmosDBForPostgreSqlClusterData(document.RootElement);
            return new CosmosDBForPostgreSqlClusterResource(_client, data);
        }
    }
}
