// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Samples
{
    public partial class Sample_CosmosDBForPostgreSqlPrivateLinkResource
    {
        // Gets a private link resource for cluster.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAPrivateLinkResourceForCluster()
        {
            // Generated from example definition: specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/stable/2022-11-08/examples/PrivateLinkResourcesGet.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBForPostgreSqlPrivateLinkResource created on azure
            // for more information of creating CosmosDBForPostgreSqlPrivateLinkResource, please refer to the document of CosmosDBForPostgreSqlPrivateLinkResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string clusterName = "testcluster";
            string privateLinkResourceName = "plr";
            ResourceIdentifier cosmosDBForPostgreSqlPrivateLinkResourceId = CosmosDBForPostgreSqlPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateLinkResourceName);
            CosmosDBForPostgreSqlPrivateLinkResource cosmosDBForPostgreSqlPrivateLinkResource = client.GetCosmosDBForPostgreSqlPrivateLinkResource(cosmosDBForPostgreSqlPrivateLinkResourceId);

            // invoke the operation
            CosmosDBForPostgreSqlPrivateLinkResource result = await cosmosDBForPostgreSqlPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBForPostgreSqlPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
