// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.CosmosDBForPostgreSql.Samples
{
    public partial class Sample_CosmosDBForPostgreSqlCoordinatorConfigurationResource
    {
        // Get configuration details for coordinator.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetConfigurationDetailsForCoordinator()
        {
            // Generated from example definition: specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/stable/2022-11-08/examples/ConfigurationGetCoordinator.json
            // this example is just showing the usage of "Configurations_GetCoordinator" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBForPostgreSqlCoordinatorConfigurationResource created on azure
            // for more information of creating CosmosDBForPostgreSqlCoordinatorConfigurationResource, please refer to the document of CosmosDBForPostgreSqlCoordinatorConfigurationResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string clusterName = "testcluster";
            string configurationName = "array_nulls";
            ResourceIdentifier cosmosDBForPostgreSqlCoordinatorConfigurationResourceId = CosmosDBForPostgreSqlCoordinatorConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, configurationName);
            CosmosDBForPostgreSqlCoordinatorConfigurationResource cosmosDBForPostgreSqlCoordinatorConfiguration = client.GetCosmosDBForPostgreSqlCoordinatorConfigurationResource(cosmosDBForPostgreSqlCoordinatorConfigurationResourceId);

            // invoke the operation
            CosmosDBForPostgreSqlCoordinatorConfigurationResource result = await cosmosDBForPostgreSqlCoordinatorConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBForPostgreSqlServerConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update single configuration of coordinator
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateSingleConfigurationOfCoordinator()
        {
            // Generated from example definition: specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/stable/2022-11-08/examples/ConfigurationUpdateCoordinator.json
            // this example is just showing the usage of "Configurations_UpdateOnCoordinator" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBForPostgreSqlCoordinatorConfigurationResource created on azure
            // for more information of creating CosmosDBForPostgreSqlCoordinatorConfigurationResource, please refer to the document of CosmosDBForPostgreSqlCoordinatorConfigurationResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string clusterName = "testcluster";
            string configurationName = "array_nulls";
            ResourceIdentifier cosmosDBForPostgreSqlCoordinatorConfigurationResourceId = CosmosDBForPostgreSqlCoordinatorConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, configurationName);
            CosmosDBForPostgreSqlCoordinatorConfigurationResource cosmosDBForPostgreSqlCoordinatorConfiguration = client.GetCosmosDBForPostgreSqlCoordinatorConfigurationResource(cosmosDBForPostgreSqlCoordinatorConfigurationResourceId);

            // invoke the operation
            CosmosDBForPostgreSqlServerConfigurationData data = new CosmosDBForPostgreSqlServerConfigurationData()
            {
                Value = "on",
            };
            ArmOperation<CosmosDBForPostgreSqlCoordinatorConfigurationResource> lro = await cosmosDBForPostgreSqlCoordinatorConfiguration.UpdateAsync(WaitUntil.Completed, data);
            CosmosDBForPostgreSqlCoordinatorConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBForPostgreSqlServerConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
