// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> ThroughputPolicy to apply for throughput redistribution. </summary>
    public readonly partial struct ThroughputPolicyType : IEquatable<ThroughputPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ThroughputPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ThroughputPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string EqualValue = "equal";
        private const string CustomValue = "custom";

        /// <summary> none. </summary>
        public static ThroughputPolicyType None { get; } = new ThroughputPolicyType(NoneValue);
        /// <summary> equal. </summary>
        public static ThroughputPolicyType Equal { get; } = new ThroughputPolicyType(EqualValue);
        /// <summary> custom. </summary>
        public static ThroughputPolicyType Custom { get; } = new ThroughputPolicyType(CustomValue);
        /// <summary> Determines if two <see cref="ThroughputPolicyType"/> values are the same. </summary>
        public static bool operator ==(ThroughputPolicyType left, ThroughputPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ThroughputPolicyType"/> values are not the same. </summary>
        public static bool operator !=(ThroughputPolicyType left, ThroughputPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ThroughputPolicyType"/>. </summary>
        public static implicit operator ThroughputPolicyType(string value) => new ThroughputPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ThroughputPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ThroughputPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
