// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Properties for SqlDedicatedGatewayServiceResource. </summary>
    public partial class SqlDedicatedGatewayServiceProperties : CosmosDBServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="SqlDedicatedGatewayServiceProperties"/>. </summary>
        public SqlDedicatedGatewayServiceProperties()
        {
            Locations = new ChangeTrackingList<SqlDedicatedGatewayRegionalService>();
            ServiceType = CosmosDBServiceType.SqlDedicatedGateway;
        }

        /// <summary> Initializes a new instance of <see cref="SqlDedicatedGatewayServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="serviceType"> ServiceType for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="sqlDedicatedGatewayEndpoint"> SqlDedicatedGateway endpoint for the service. </param>
        /// <param name="dedicatedGatewayType"> DedicatedGatewayType for the service. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        internal SqlDedicatedGatewayServiceProperties(DateTimeOffset? createdOn, CosmosDBServiceSize? instanceSize, int? instanceCount, CosmosDBServiceType serviceType, CosmosDBServiceStatus? status, IDictionary<string, BinaryData> additionalProperties, string sqlDedicatedGatewayEndpoint, DedicatedGatewayType? dedicatedGatewayType, IReadOnlyList<SqlDedicatedGatewayRegionalService> locations) : base(createdOn, instanceSize, instanceCount, serviceType, status, additionalProperties)
        {
            SqlDedicatedGatewayEndpoint = sqlDedicatedGatewayEndpoint;
            DedicatedGatewayType = dedicatedGatewayType;
            Locations = locations;
            ServiceType = serviceType;
        }

        /// <summary> SqlDedicatedGateway endpoint for the service. </summary>
        [WirePath("sqlDedicatedGatewayEndpoint")]
        public string SqlDedicatedGatewayEndpoint { get; set; }
        /// <summary> DedicatedGatewayType for the service. </summary>
        [WirePath("dedicatedGatewayType")]
        public DedicatedGatewayType? DedicatedGatewayType { get; set; }
        /// <summary> An array that contains all of the locations for the service. </summary>
        [WirePath("locations")]
        public IReadOnlyList<SqlDedicatedGatewayRegionalService> Locations { get; }
    }
}
