// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    [PersistableModelProxy(typeof(UnknownServiceResourceCreateUpdateProperties))]
    public partial class ServiceResourceCreateUpdateProperties : IUtf8JsonSerializable, IJsonModel<ServiceResourceCreateUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServiceResourceCreateUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServiceResourceCreateUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceResourceCreateUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceResourceCreateUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(InstanceSize))
            {
                writer.WritePropertyName("instanceSize"u8);
                writer.WriteStringValue(InstanceSize.Value.ToString());
            }
            if (Optional.IsDefined(InstanceCount))
            {
                writer.WritePropertyName("instanceCount"u8);
                writer.WriteNumberValue(InstanceCount.Value);
            }
            writer.WritePropertyName("serviceType"u8);
            writer.WriteStringValue(ServiceType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServiceResourceCreateUpdateProperties IJsonModel<ServiceResourceCreateUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceResourceCreateUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceResourceCreateUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServiceResourceCreateUpdateProperties(document.RootElement, options);
        }

        internal static ServiceResourceCreateUpdateProperties DeserializeServiceResourceCreateUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("serviceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "DataTransfer": return DataTransferServiceResourceCreateUpdateProperties.DeserializeDataTransferServiceResourceCreateUpdateProperties(element, options);
                    case "GraphAPICompute": return GraphApiComputeServiceResourceCreateUpdateProperties.DeserializeGraphApiComputeServiceResourceCreateUpdateProperties(element, options);
                    case "MaterializedViewsBuilder": return MaterializedViewsBuilderServiceResourceCreateUpdateProperties.DeserializeMaterializedViewsBuilderServiceResourceCreateUpdateProperties(element, options);
                    case "SqlDedicatedGateway": return SqlDedicatedGatewayServiceResourceCreateUpdateProperties.DeserializeSqlDedicatedGatewayServiceResourceCreateUpdateProperties(element, options);
                }
            }
            return UnknownServiceResourceCreateUpdateProperties.DeserializeUnknownServiceResourceCreateUpdateProperties(element, options);
        }

        BinaryData IPersistableModel<ServiceResourceCreateUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceResourceCreateUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServiceResourceCreateUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServiceResourceCreateUpdateProperties IPersistableModel<ServiceResourceCreateUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceResourceCreateUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServiceResourceCreateUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServiceResourceCreateUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServiceResourceCreateUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
