// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> How to connect to the azure services needed for running the cluster. </summary>
    public readonly partial struct ServiceConnectionType : IEquatable<ServiceConnectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceConnectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceConnectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string VpnValue = "VPN";

        /// <summary> None. </summary>
        public static ServiceConnectionType None { get; } = new ServiceConnectionType(NoneValue);
        /// <summary> VPN. </summary>
        public static ServiceConnectionType Vpn { get; } = new ServiceConnectionType(VpnValue);
        /// <summary> Determines if two <see cref="ServiceConnectionType"/> values are the same. </summary>
        public static bool operator ==(ServiceConnectionType left, ServiceConnectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceConnectionType"/> values are not the same. </summary>
        public static bool operator !=(ServiceConnectionType left, ServiceConnectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceConnectionType"/>. </summary>
        public static implicit operator ServiceConnectionType(string value) => new ServiceConnectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceConnectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceConnectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
