// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> How the nodes in the cluster react to scheduled events. </summary>
    public readonly partial struct ScheduledEventStrategy : IEquatable<ScheduledEventStrategy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduledEventStrategy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduledEventStrategy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IgnoreValue = "Ignore";
        private const string StopAnyValue = "StopAny";
        private const string StopByRackValue = "StopByRack";

        /// <summary> Ignore. </summary>
        public static ScheduledEventStrategy Ignore { get; } = new ScheduledEventStrategy(IgnoreValue);
        /// <summary> StopAny. </summary>
        public static ScheduledEventStrategy StopAny { get; } = new ScheduledEventStrategy(StopAnyValue);
        /// <summary> StopByRack. </summary>
        public static ScheduledEventStrategy StopByRack { get; } = new ScheduledEventStrategy(StopByRackValue);
        /// <summary> Determines if two <see cref="ScheduledEventStrategy"/> values are the same. </summary>
        public static bool operator ==(ScheduledEventStrategy left, ScheduledEventStrategy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduledEventStrategy"/> values are not the same. </summary>
        public static bool operator !=(ScheduledEventStrategy left, ScheduledEventStrategy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduledEventStrategy"/>. </summary>
        public static implicit operator ScheduledEventStrategy(string value) => new ScheduledEventStrategy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduledEventStrategy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduledEventStrategy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
