// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object. </summary>
    public partial class PhysicalPartitionThroughputInfoResult : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PhysicalPartitionThroughputInfoResult"/>. </summary>
        /// <param name="location"> The location. </param>
        public PhysicalPartitionThroughputInfoResult(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="PhysicalPartitionThroughputInfoResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> properties of physical partition throughput info. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PhysicalPartitionThroughputInfoResult(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, PhysicalPartitionThroughputInfoResultPropertiesResource resource, ManagedServiceIdentity identity, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Resource = resource;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PhysicalPartitionThroughputInfoResult"/> for deserialization. </summary>
        internal PhysicalPartitionThroughputInfoResult()
        {
        }

        /// <summary> properties of physical partition throughput info. </summary>
        internal PhysicalPartitionThroughputInfoResultPropertiesResource Resource { get; set; }
        /// <summary> Array of physical partition throughput info objects. </summary>
        [WirePath("properties.resource.physicalPartitionThroughputInfo")]
        public IList<PhysicalPartitionThroughputInfoResource> ResourcePhysicalPartitionThroughputInfo
        {
            get
            {
                if (Resource is null)
                    Resource = new PhysicalPartitionThroughputInfoResultPropertiesResource();
                return Resource.PhysicalPartitionThroughputInfo;
            }
        }

        /// <summary> Identity for the resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
    }
}
