// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The partition level usage data for a usage request. </summary>
    public partial class PartitionUsage : CosmosDBBaseUsage
    {
        /// <summary> Initializes a new instance of <see cref="PartitionUsage"/>. </summary>
        internal PartitionUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartitionUsage"/>. </summary>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="quotaPeriod"> The quota period used to summarize the usage values. </param>
        /// <param name="limit"> Maximum value for this metric. </param>
        /// <param name="currentValue"> Current value for this metric. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="partitionId"> The partition id (GUID identifier) of the usages. </param>
        /// <param name="partitionKeyRangeId"> The partition key range id (integer identifier) of the usages. </param>
        internal PartitionUsage(CosmosDBMetricUnitType? unit, CosmosDBMetricName name, string quotaPeriod, long? limit, long? currentValue, IDictionary<string, BinaryData> serializedAdditionalRawData, Guid? partitionId, string partitionKeyRangeId) : base(unit, name, quotaPeriod, limit, currentValue, serializedAdditionalRawData)
        {
            PartitionId = partitionId;
            PartitionKeyRangeId = partitionKeyRangeId;
        }

        /// <summary> The partition id (GUID identifier) of the usages. </summary>
        [WirePath("partitionId")]
        public Guid? PartitionId { get; }
        /// <summary> The partition key range id (integer identifier) of the usages. </summary>
        [WirePath("partitionKeyRangeId")]
        public string PartitionKeyRangeId { get; }
    }
}
