// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Network security configuration properties. </summary>
    public partial class NetworkSecurityPerimeterConfigurationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationProperties"/>. </summary>
        public NetworkSecurityPerimeterConfigurationProperties()
        {
            ProvisioningIssues = new ChangeTrackingList<ProvisioningIssue>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of a network security perimeter configuration that is being created or updated. </param>
        /// <param name="provisioningIssues"> List of provisioning issues, if any. </param>
        /// <param name="networkSecurityPerimeter"> Information about a network security perimeter (NSP). </param>
        /// <param name="resourceAssociation"> Information about resource association. </param>
        /// <param name="profile"> Network security perimeter configuration profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeterConfigurationProperties(NetworkSecurityPerimeterConfigurationProvisioningState? provisioningState, IReadOnlyList<ProvisioningIssue> provisioningIssues, NetworkSecurityPerimeter networkSecurityPerimeter, ResourceAssociation resourceAssociation, NetworkSecurityProfile profile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            ProvisioningIssues = provisioningIssues;
            NetworkSecurityPerimeter = networkSecurityPerimeter;
            ResourceAssociation = resourceAssociation;
            Profile = profile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Provisioning state of a network security perimeter configuration that is being created or updated. </summary>
        [WirePath("provisioningState")]
        public NetworkSecurityPerimeterConfigurationProvisioningState? ProvisioningState { get; }
        /// <summary> List of provisioning issues, if any. </summary>
        [WirePath("provisioningIssues")]
        public IReadOnlyList<ProvisioningIssue> ProvisioningIssues { get; }
        /// <summary> Information about a network security perimeter (NSP). </summary>
        [WirePath("networkSecurityPerimeter")]
        public NetworkSecurityPerimeter NetworkSecurityPerimeter { get; set; }
        /// <summary> Information about resource association. </summary>
        [WirePath("resourceAssociation")]
        public ResourceAssociation ResourceAssociation { get; set; }
        /// <summary> Network security perimeter configuration profile. </summary>
        [WirePath("profile")]
        public NetworkSecurityProfile Profile { get; set; }
    }
}
