// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Cosmos DB MongoDB collection index key. </summary>
    public partial class MongoDBIndex
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MongoDBIndex"/>. </summary>
        public MongoDBIndex()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MongoDBIndex"/>. </summary>
        /// <param name="key"> Cosmos DB MongoDB collection index keys. </param>
        /// <param name="options"> Cosmos DB MongoDB collection index key options. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MongoDBIndex(MongoIndexKeys key, MongoDBIndexConfig options, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Key = key;
            Options = options;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cosmos DB MongoDB collection index keys. </summary>
        internal MongoIndexKeys Key { get; set; }
        /// <summary> List of keys for each MongoDB collection in the Azure Cosmos DB service. </summary>
        [WirePath("key.keys")]
        public IList<string> Keys
        {
            get
            {
                if (Key is null)
                    Key = new MongoIndexKeys();
                return Key.Keys;
            }
        }

        /// <summary> Cosmos DB MongoDB collection index key options. </summary>
        [WirePath("options")]
        public MongoDBIndexConfig Options { get; set; }
    }
}
