// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Properties for MaterializedViewsBuilderServiceResource. </summary>
    public partial class MaterializedViewsBuilderServiceProperties : CosmosDBServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="MaterializedViewsBuilderServiceProperties"/>. </summary>
        public MaterializedViewsBuilderServiceProperties()
        {
            Locations = new ChangeTrackingList<MaterializedViewsBuilderRegionalService>();
            ServiceType = CosmosDBServiceType.MaterializedViewsBuilder;
        }

        /// <summary> Initializes a new instance of <see cref="MaterializedViewsBuilderServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="serviceType"> ServiceType for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        internal MaterializedViewsBuilderServiceProperties(DateTimeOffset? createdOn, CosmosDBServiceSize? instanceSize, int? instanceCount, CosmosDBServiceType serviceType, CosmosDBServiceStatus? status, IDictionary<string, BinaryData> additionalProperties, IReadOnlyList<MaterializedViewsBuilderRegionalService> locations) : base(createdOn, instanceSize, instanceCount, serviceType, status, additionalProperties)
        {
            Locations = locations;
            ServiceType = serviceType;
        }

        /// <summary> An array that contains all of the locations for the service. </summary>
        [WirePath("locations")]
        public IReadOnlyList<MaterializedViewsBuilderRegionalService> Locations { get; }
    }
}
