// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates what diagnostic log settings are to be enabled. </summary>
    internal partial class DiagnosticLogSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticLogSettings"/>. </summary>
        public DiagnosticLogSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticLogSettings"/>. </summary>
        /// <param name="enableFullTextQuery"> Describe the level of detail with which queries are to be logged. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticLogSettings(EnableFullTextQuery? enableFullTextQuery, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EnableFullTextQuery = enableFullTextQuery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describe the level of detail with which queries are to be logged. </summary>
        [WirePath("enableFullTextQuery")]
        public EnableFullTextQuery? EnableFullTextQuery { get; set; }
    }
}
